<?php
defined('ABSPATH') || exit;

if (!function_exists('yatra_get_currencies')) {
    function yatra_get_currencies($currency_key = '')
    {
        $currencies = array_unique(
            apply_filters('yatra_currencies',
                array(
                    'AED' => __('United Arab Emirates dirham', 'yatra'),
                    'AFN' => __('Afghan afghani', 'yatra'),
                    'ALL' => __('Albanian lek', 'yatra'),
                    'AMD' => __('Armenian dram', 'yatra'),
                    'ANG' => __('Netherlands Antillean guilder', 'yatra'),
                    'AOA' => __('Angolan kwanza', 'yatra'),
                    'ARS' => __('Argentine peso', 'yatra'),
                    'AUD' => __('Australian dollar', 'yatra'),
                    'AWG' => __('Aruban florin', 'yatra'),
                    'AZN' => __('Azerbaijani manat', 'yatra'),
                    'BAM' => __('Bosnia and Herzegovina convertible mark', 'yatra'),
                    'BBD' => __('Barbadian dollar', 'yatra'),
                    'BDT' => __('Bangladeshi taka', 'yatra'),
                    'BGN' => __('Bulgarian lev', 'yatra'),
                    'BHD' => __('Bahraini dinar', 'yatra'),
                    'BIF' => __('Burundian franc', 'yatra'),
                    'BMD' => __('Bermudian dollar', 'yatra'),
                    'BND' => __('Brunei dollar', 'yatra'),
                    'BOB' => __('Bolivian boliviano', 'yatra'),
                    'BRL' => __('Brazilian real', 'yatra'),
                    'BSD' => __('Bahamian dollar', 'yatra'),
                    'BTC' => __('Bitcoin', 'yatra'),
                    'BTN' => __('Bhutanese ngultrum', 'yatra'),
                    'BWP' => __('Botswana pula', 'yatra'),
                    'BYR' => __('Belarusian ruble (old)', 'yatra'),
                    'BYN' => __('Belarusian ruble', 'yatra'),
                    'BZD' => __('Belize dollar', 'yatra'),
                    'CAD' => __('Canadian dollar', 'yatra'),
                    'CDF' => __('Congolese franc', 'yatra'),
                    'CHF' => __('Swiss franc', 'yatra'),
                    'CLP' => __('Chilean peso', 'yatra'),
                    'CNY' => __('Chinese yuan', 'yatra'),
                    'COP' => __('Colombian peso', 'yatra'),
                    'CRC' => __('Costa Rican col&oacute;n', 'yatra'),
                    'CUC' => __('Cuban convertible peso', 'yatra'),
                    'CUP' => __('Cuban peso', 'yatra'),
                    'CVE' => __('Cape Verdean escudo', 'yatra'),
                    'CZK' => __('Czech koruna', 'yatra'),
                    'DJF' => __('Djiboutian franc', 'yatra'),
                    'DKK' => __('Danish krone', 'yatra'),
                    'DOP' => __('Dominican peso', 'yatra'),
                    'DZD' => __('Algerian dinar', 'yatra'),
                    'EGP' => __('Egyptian pound', 'yatra'),
                    'ERN' => __('Eritrean nakfa', 'yatra'),
                    'ETB' => __('Ethiopian birr', 'yatra'),
                    'EUR' => __('Euro', 'yatra'),
                    'FJD' => __('Fijian dollar', 'yatra'),
                    'FKP' => __('Falkland Islands pound', 'yatra'),
                    'GBP' => __('Pound sterling', 'yatra'),
                    'GEL' => __('Georgian lari', 'yatra'),
                    'GGP' => __('Guernsey pound', 'yatra'),
                    'GHS' => __('Ghana cedi', 'yatra'),
                    'GIP' => __('Gibraltar pound', 'yatra'),
                    'GMD' => __('Gambian dalasi', 'yatra'),
                    'GNF' => __('Guinean franc', 'yatra'),
                    'GTQ' => __('Guatemalan quetzal', 'yatra'),
                    'GYD' => __('Guyanese dollar', 'yatra'),
                    'HKD' => __('Hong Kong dollar', 'yatra'),
                    'HNL' => __('Honduran lempira', 'yatra'),
                    'HRK' => __('Croatian kuna', 'yatra'),
                    'HTG' => __('Haitian gourde', 'yatra'),
                    'HUF' => __('Hungarian forint', 'yatra'),
                    'IDR' => __('Indonesian rupiah', 'yatra'),
                    'ILS' => __('Israeli new shekel', 'yatra'),
                    'IMP' => __('Manx pound', 'yatra'),
                    'INR' => __('Indian rupee', 'yatra'),
                    'IQD' => __('Iraqi dinar', 'yatra'),
                    'IRR' => __('Iranian rial', 'yatra'),
                    'IRT' => __('Iranian toman', 'yatra'),
                    'ISK' => __('Icelandic kr&oacute;na', 'yatra'),
                    'JEP' => __('Jersey pound', 'yatra'),
                    'JMD' => __('Jamaican dollar', 'yatra'),
                    'JOD' => __('Jordanian dinar', 'yatra'),
                    'JPY' => __('Japanese yen', 'yatra'),
                    'KES' => __('Kenyan shilling', 'yatra'),
                    'KGS' => __('Kyrgyzstani som', 'yatra'),
                    'KHR' => __('Cambodian riel', 'yatra'),
                    'KMF' => __('Comorian franc', 'yatra'),
                    'KPW' => __('North Korean won', 'yatra'),
                    'KRW' => __('South Korean won', 'yatra'),
                    'KWD' => __('Kuwaiti dinar', 'yatra'),
                    'KYD' => __('Cayman Islands dollar', 'yatra'),
                    'KZT' => __('Kazakhstani tenge', 'yatra'),
                    'LAK' => __('Lao kip', 'yatra'),
                    'LBP' => __('Lebanese pound', 'yatra'),
                    'LKR' => __('Sri Lankan rupee', 'yatra'),
                    'LRD' => __('Liberian dollar', 'yatra'),
                    'LSL' => __('Lesotho loti', 'yatra'),
                    'LYD' => __('Libyan dinar', 'yatra'),
                    'MAD' => __('Moroccan dirham', 'yatra'),
                    'MDL' => __('Moldovan leu', 'yatra'),
                    'MGA' => __('Malagasy ariary', 'yatra'),
                    'MKD' => __('Macedonian denar', 'yatra'),
                    'MMK' => __('Burmese kyat', 'yatra'),
                    'MNT' => __('Mongolian t&ouml;gr&ouml;g', 'yatra'),
                    'MOP' => __('Macanese pataca', 'yatra'),
                    'MRO' => __('Mauritanian ouguiya', 'yatra'),
                    'MUR' => __('Mauritian rupee', 'yatra'),
                    'MVR' => __('Maldivian rufiyaa', 'yatra'),
                    'MWK' => __('Malawian kwacha', 'yatra'),
                    'MXN' => __('Mexican peso', 'yatra'),
                    'MYR' => __('Malaysian ringgit', 'yatra'),
                    'MZN' => __('Mozambican metical', 'yatra'),
                    'NAD' => __('Namibian dollar', 'yatra'),
                    'NGN' => __('Nigerian naira', 'yatra'),
                    'NIO' => __('Nicaraguan c&oacute;rdoba', 'yatra'),
                    'NOK' => __('Norwegian krone', 'yatra'),
                    'NPR' => __('Nepalese rupee', 'yatra'),
                    'NZD' => __('New Zealand dollar', 'yatra'),
                    'OMR' => __('Omani rial', 'yatra'),
                    'PAB' => __('Panamanian balboa', 'yatra'),
                    'PEN' => __('Peruvian nuevo sol', 'yatra'),
                    'PGK' => __('Papua New Guinean kina', 'yatra'),
                    'PHP' => __('Philippine peso', 'yatra'),
                    'PKR' => __('Pakistani rupee', 'yatra'),
                    'PLN' => __('Polish z&#x142;oty', 'yatra'),
                    'PRB' => __('Transnistrian ruble', 'yatra'),
                    'PYG' => __('Paraguayan guaran&iacute;', 'yatra'),
                    'QAR' => __('Qatari riyal', 'yatra'),
                    'RON' => __('Romanian leu', 'yatra'),
                    'RSD' => __('Serbian dinar', 'yatra'),
                    'RUB' => __('Russian ruble', 'yatra'),
                    'RWF' => __('Rwandan franc', 'yatra'),
                    'SAR' => __('Saudi riyal', 'yatra'),
                    'SBD' => __('Solomon Islands dollar', 'yatra'),
                    'SCR' => __('Seychellois rupee', 'yatra'),
                    'SDG' => __('Sudanese pound', 'yatra'),
                    'SEK' => __('Swedish krona', 'yatra'),
                    'SGD' => __('Singapore dollar', 'yatra'),
                    'SHP' => __('Saint Helena pound', 'yatra'),
                    'SLL' => __('Sierra Leonean leone', 'yatra'),
                    'SOS' => __('Somali shilling', 'yatra'),
                    'SRD' => __('Surinamese dollar', 'yatra'),
                    'SSP' => __('South Sudanese pound', 'yatra'),
                    'STD' => __('S&atilde;o Tom&eacute; and Pr&iacute;ncipe dobra', 'yatra'),
                    'SYP' => __('Syrian pound', 'yatra'),
                    'SZL' => __('Swazi lilangeni', 'yatra'),
                    'THB' => __('Thai baht', 'yatra'),
                    'TJS' => __('Tajikistani somoni', 'yatra'),
                    'TMT' => __('Turkmenistan manat', 'yatra'),
                    'TND' => __('Tunisian dinar', 'yatra'),
                    'TOP' => __('Tongan pa&#x2bb;anga', 'yatra'),
                    'TRY' => __('Turkish lira', 'yatra'),
                    'TTD' => __('Trinidad and Tobago dollar', 'yatra'),
                    'TWD' => __('New Taiwan dollar', 'yatra'),
                    'TZS' => __('Tanzanian shilling', 'yatra'),
                    'UAH' => __('Ukrainian hryvnia', 'yatra'),
                    'UGX' => __('Ugandan shilling', 'yatra'),
                    'USD' => __('United States (US) dollar', 'yatra'),
                    'UYU' => __('Uruguayan peso', 'yatra'),
                    'UZS' => __('Uzbekistani som', 'yatra'),
                    'VEF' => __('Venezuelan bol&iacute;var', 'yatra'),
                    'VND' => __('Vietnamese &#x111;&#x1ed3;ng', 'yatra'),
                    'VUV' => __('Vanuatu vatu', 'yatra'),
                    'WST' => __('Samoan t&#x101;l&#x101;', 'yatra'),
                    'XAF' => __('Central African CFA franc', 'yatra'),
                    'XCD' => __('East Caribbean dollar', 'yatra'),
                    'XOF' => __('West African CFA franc', 'yatra'),
                    'XPF' => __('CFP franc', 'yatra'),
                    'YER' => __('Yemeni rial', 'yatra'),
                    'ZAR' => __('South African rand', 'yatra'),
                    'ZMW' => __('Zambian kwacha', 'yatra'),
                )
            )
        );

        if (!empty($currency_key) && isset($currencies[$currency_key])) {

            return $currencies[$currency_key];
        }
        return $currencies;
    }
}

if (!function_exists('yatra_get_currency_symbol')) {
    function yatra_get_currency_symbol($currency_key = '')
    {
        $symbols = apply_filters('yatra_currency_symbols', array(
            'AED' => '&#x62f;.&#x625;',
            'AFN' => '&#x60b;',
            'ALL' => 'L',
            'AMD' => 'AMD',
            'ANG' => '&fnof;',
            'AOA' => 'Kz',
            'ARS' => '&#36;',
            'AUD' => '&#36;',
            'AWG' => 'Afl.',
            'AZN' => 'AZN',
            'BAM' => 'KM',
            'BBD' => '&#36;',
            'BDT' => '&#2547;&nbsp;',
            'BGN' => '&#1083;&#1074;.',
            'BHD' => '.&#x62f;.&#x628;',
            'BIF' => 'Fr',
            'BMD' => '&#36;',
            'BND' => '&#36;',
            'BOB' => 'Bs.',
            'BRL' => '&#82;&#36;',
            'BSD' => '&#36;',
            'BTC' => '&#3647;',
            'BTN' => 'Nu.',
            'BWP' => 'P',
            'BYR' => 'Br',
            'BYN' => 'Br',
            'BZD' => '&#36;',
            'CAD' => '&#36;',
            'CDF' => 'Fr',
            'CHF' => '&#67;&#72;&#70;',
            'CLP' => '&#36;',
            'CNY' => '&yen;',
            'COP' => '&#36;',
            'CRC' => '&#x20a1;',
            'CUC' => '&#36;',
            'CUP' => '&#36;',
            'CVE' => '&#36;',
            'CZK' => '&#75;&#269;',
            'DJF' => 'Fr',
            'DKK' => 'DKK',
            'DOP' => 'RD&#36;',
            'DZD' => '&#x62f;.&#x62c;',
            'EGP' => 'EGP',
            'ERN' => 'Nfk',
            'ETB' => 'Br',
            'EUR' => '&euro;',
            'FJD' => '&#36;',
            'FKP' => '&pound;',
            'GBP' => '&pound;',
            'GEL' => '&#x20be;',
            'GGP' => '&pound;',
            'GHS' => '&#x20b5;',
            'GIP' => '&pound;',
            'GMD' => 'D',
            'GNF' => 'Fr',
            'GTQ' => 'Q',
            'GYD' => '&#36;',
            'HKD' => '&#36;',
            'HNL' => 'L',
            'HRK' => 'kn',
            'HTG' => 'G',
            'HUF' => '&#70;&#116;',
            'IDR' => 'Rp',
            'ILS' => '&#8362;',
            'IMP' => '&pound;',
            'INR' => '&#8377;',
            'IQD' => '&#x639;.&#x62f;',
            'IRR' => '&#xfdfc;',
            'IRT' => '&#x062A;&#x0648;&#x0645;&#x0627;&#x0646;',
            'ISK' => 'kr.',
            'JEP' => '&pound;',
            'JMD' => '&#36;',
            'JOD' => '&#x62f;.&#x627;',
            'JPY' => '&yen;',
            'KES' => 'KSh',
            'KGS' => '&#x441;&#x43e;&#x43c;',
            'KHR' => '&#x17db;',
            'KMF' => 'Fr',
            'KPW' => '&#x20a9;',
            'KRW' => '&#8361;',
            'KWD' => '&#x62f;.&#x643;',
            'KYD' => '&#36;',
            'KZT' => 'KZT',
            'LAK' => '&#8365;',
            'LBP' => '&#x644;.&#x644;',
            'LKR' => '&#xdbb;&#xdd4;',
            'LRD' => '&#36;',
            'LSL' => 'L',
            'LYD' => '&#x644;.&#x62f;',
            'MAD' => '&#x62f;.&#x645;.',
            'MDL' => 'MDL',
            'MGA' => 'Ar',
            'MKD' => '&#x434;&#x435;&#x43d;',
            'MMK' => 'Ks',
            'MNT' => '&#x20ae;',
            'MOP' => 'P',
            'MRO' => 'UM',
            'MUR' => '&#x20a8;',
            'MVR' => '.&#x783;',
            'MWK' => 'MK',
            'MXN' => '&#36;',
            'MYR' => '&#82;&#77;',
            'MZN' => 'MT',
            'NAD' => '&#36;',
            'NGN' => '&#8358;',
            'NIO' => 'C&#36;',
            'NOK' => '&#107;&#114;',
            'NPR' => '&#8360;',
            'NZD' => '&#36;',
            'OMR' => '&#x631;.&#x639;.',
            'PAB' => 'B/.',
            'PEN' => 'S/.',
            'PGK' => 'K',
            'PHP' => '&#8369;',
            'PKR' => '&#8360;',
            'PLN' => '&#122;&#322;',
            'PRB' => '&#x440;.',
            'PYG' => '&#8370;',
            'QAR' => '&#x631;.&#x642;',
            'RMB' => '&yen;',
            'RON' => 'lei',
            'RSD' => '&#x434;&#x438;&#x43d;.',
            'RUB' => '&#8381;',
            'RWF' => 'Fr',
            'SAR' => '&#x631;.&#x633;',
            'SBD' => '&#36;',
            'SCR' => '&#x20a8;',
            'SDG' => '&#x62c;.&#x633;.',
            'SEK' => '&#107;&#114;',
            'SGD' => '&#36;',
            'SHP' => '&pound;',
            'SLL' => 'Le',
            'SOS' => 'Sh',
            'SRD' => '&#36;',
            'SSP' => '&pound;',
            'STD' => 'Db',
            'SYP' => '&#x644;.&#x633;',
            'SZL' => 'L',
            'THB' => '&#3647;',
            'TJS' => '&#x405;&#x41c;',
            'TMT' => 'm',
            'TND' => '&#x62f;.&#x62a;',
            'TOP' => 'T&#36;',
            'TRY' => '&#8378;',
            'TTD' => '&#36;',
            'TWD' => '&#78;&#84;&#36;',
            'TZS' => 'Sh',
            'UAH' => '&#8372;',
            'UGX' => 'UGX',
            'USD' => '&#36;',
            'UYU' => '&#36;',
            'UZS' => 'UZS',
            'VEF' => 'Bs F',
            'VND' => '&#8363;',
            'VUV' => 'Vt',
            'WST' => 'T',
            'XAF' => 'CFA',
            'XCD' => '&#36;',
            'XOF' => 'CFA',
            'XPF' => 'Fr',
            'YER' => '&#xfdfc;',
            'ZAR' => '&#82;',
            'ZMW' => 'ZK',
        ));

        $currency_symbol = isset($symbols[$currency_key]) ? $symbols[$currency_key] : '';

        return apply_filters('yatra_currency_symbol', $currency_symbol, $currency_key);
    }
}

if (!function_exists('yatra_get_currency_with_symbol')) {

    function yatra_get_currency_with_symbol($currency_position = 'right')
    {
        $currency = yatra_get_currencies();

        $currency_with_symbol = array();

        foreach ($currency as $currency_key => $currency_value) {

            $symbol = yatra_get_currency_symbol($currency_key);

            $value = !empty($symbol) ? ' (' . $symbol . ') ' : '';

            $value = $currency_position == "left" ? $value . $currency_value : $currency_value . $value;

            $currency_with_symbol[$currency_key] = $value;
        }

        return $currency_with_symbol;
    }
}
if (!function_exists('yatra_get_currency_positions')) {

    function yatra_get_currency_positions()
    {


        return [
            'left' => __('Left', 'yatra'),
            'right' => __('Right', 'yatra'),
            'left_space' => __('Left with space', 'yatra'),
            'right_space' => __('Right with space', 'yatra')

        ];
    }
}