<?php
defined('ABSPATH') || exit;

if (!function_exists('yatra_get_countries')) {
    function yatra_get_countries($country_key = null)
    {
        $countries =
            array_unique(
                apply_filters(
                    'yatra_countries',
                    array(
                        "AF" => __("Afghanistan", 'yatra'),
                        "AL" => __("Albania", "yatra"),
                        "DZ" => __("Algeria", "yatra"),
                        "AS" => __("American Samoa", "yatra"),
                        "AD" => __("Andorra", "yatra"),
                        "AO" => __("Angola", "yatra"),
                        "AI" => __("Anguilla", "yatra"),
                        "AQ" => __("Antarctica", "yatra"),
                        "AG" => __("Antigua and Barbuda", "yatra"),
                        "AR" => __("Argentina", "yatra"),
                        "AM" => __("Armenia", "yatra"),
                        "AW" => __("Aruba", "yatra"),
                        "AU" => __("Australia", "yatra"),
                        "AT" => __("Austria", "yatra"),
                        "AZ" => __("Azerbaijan", "yatra"),
                        "BS" => __("Bahamas", "yatra"),
                        "BH" => __("Bahrain", "yatra"),
                        "BD" => __("Bangladesh", "yatra"),
                        "BB" => __("Barbados", "yatra"),
                        "BY" => __("Belarus", "yatra"),
                        "BE" => __("Belgium", "yatra"),
                        "BZ" => __("Belize", "yatra"),
                        "BJ" => __("Benin", "yatra"),
                        "BM" => __("Bermuda", "yatra"),
                        "BT" => __("Bhutan", "yatra"),
                        "BO" => __("Bolivia", "yatra"),
                        "BA" => __("Bosnia and Herzegovina", "yatra"),
                        "BW" => __("Botswana", "yatra"),
                        "BV" => __("Bouvet Island", "yatra"),
                        "BR" => __("Brazil", "yatra"),
                        "IO" => __("British Indian Ocean Territory", "yatra"),
                        "BN" => __("Brunei Darussalam", "yatra"),
                        "BG" => __("Bulgaria", "yatra"),
                        "BF" => __("Burkina Faso", "yatra"),
                        "BI" => __("Burundi", "yatra"),
                        "KH" => __("Cambodia", "yatra"),
                        "CM" => __("Cameroon", "yatra"),
                        "CA" => __("Canada", "yatra"),
                        "CV" => __("Cape Verde", "yatra"),
                        "KY" => __("Cayman Islands", "yatra"),
                        "CF" => __("Central African Republic", "yatra"),
                        "TD" => __("Chad", "yatra"),
                        "CL" => __("Chile", "yatra"),
                        "CN" => __("China", "yatra"),
                        "CX" => __("Christmas Island", "yatra"),
                        "CC" => __("Cocos (Keeling) Islands", "yatra"),
                        "CO" => __("Colombia", "yatra"),
                        "KM" => __("Comoros", "yatra"),
                        "CG" => __("Congo", "yatra"),
                        "CD" => __("Congo, the Democratic Republic of the", "yatra"),
                        "CK" => __("Cook Islands", "yatra"),
                        "CR" => __("Costa Rica", "yatra"),
                        "CI" => __("Cote D'Ivoire", "yatra"),
                        "HR" => __("Croatia", "yatra"),
                        "CU" => __("Cuba", "yatra"),
                        "CY" => __("Cyprus", "yatra"),
                        "CZ" => __("Czech Republic", "yatra"),
                        "DK" => __("Denmark", "yatra"),
                        "DJ" => __("Djibouti", "yatra"),
                        "DM" => __("Dominica", "yatra"),
                        "DO" => __("Dominican Republic", "yatra"),
                        "EC" => __("Ecuador", "yatra"),
                        "EG" => __("Egypt", "yatra"),
                        "SV" => __("El Salvador", "yatra"),
                        "GQ" => __("Equatorial Guinea", "yatra"),
                        "ER" => __("Eritrea", "yatra"),
                        "EE" => __("Estonia", "yatra"),
                        "ET" => __("Ethiopia", "yatra"),
                        "FK" => __("Falkland Islands (Malvinas)", "yatra"),
                        "FO" => __("Faroe Islands", "yatra"),
                        "FJ" => __("Fiji", "yatra"),
                        "FI" => __("Finland", "yatra"),
                        "FR" => __("France", "yatra"),
                        "GF" => __("French Guiana", "yatra"),
                        "PF" => __("French Polynesia", "yatra"),
                        "TF" => __("French Southern Territories", "yatra"),
                        "GA" => __("Gabon", "yatra"),
                        "GM" => __("Gambia", "yatra"),
                        "GE" => __("Georgia", "yatra"),
                        "DE" => __("Germany", "yatra"),
                        "GH" => __("Ghana", "yatra"),
                        "GI" => __("Gibraltar", "yatra"),
                        "GR" => __("Greece", "yatra"),
                        "GL" => __("Greenland", "yatra"),
                        "GD" => __("Grenada", "yatra"),
                        "GP" => __("Guadeloupe", "yatra"),
                        "GU" => __("Guam", "yatra"),
                        "GT" => __("Guatemala", "yatra"),
                        "GN" => __("Guinea", "yatra"),
                        "GW" => __("Guinea-Bissau", "yatra"),
                        "GY" => __("Guyana", "yatra"),
                        "HT" => __("Haiti", "yatra"),
                        "HM" => __("Heard Island and Mcdonald Islands", "yatra"),
                        "VA" => __("Holy See (Vatican City State)", "yatra"),
                        "HN" => __("Honduras", "yatra"),
                        "HK" => __("Hong Kong", "yatra"),
                        "HU" => __("Hungary", "yatra"),
                        "IS" => __("Iceland", "yatra"),
                        "IN" => __("India", "yatra"),
                        "ID" => __("Indonesia", "yatra"),
                        "IR" => __("Iran, Islamic Republic of", "yatra"),
                        "IQ" => __("Iraq", "yatra"),
                        "IE" => __("Ireland", "yatra"),
                        "IL" => __("Israel", "yatra"),
                        "IT" => __("Italy", "yatra"),
                        "JM" => __("Jamaica", "yatra"),
                        "JP" => __("Japan", "yatra"),
                        "JO" => __("Jordan", "yatra"),
                        "KZ" => __("Kazakhstan", "yatra"),
                        "KE" => __("Kenya", "yatra"),
                        "KI" => __("Kiribati", "yatra"),
                        "KP" => __("Korea, Democratic People's Republic of", "yatra"),
                        "KR" => __("Korea, Republic of", "yatra"),
                        "KW" => __("Kuwait", "yatra"),
                        "KG" => __("Kyrgyzstan", "yatra"),
                        "LA" => __("Lao People's Democratic Republic", "yatra"),
                        "LV" => __("Latvia", "yatra"),
                        "LB" => __("Lebanon", "yatra"),
                        "LS" => __("Lesotho", "yatra"),
                        "LR" => __("Liberia", "yatra"),
                        "LY" => __("Libyan Arab Jamahiriya", "yatra"),
                        "LI" => __("Liechtenstein", "yatra"),
                        "LT" => __("Lithuania", "yatra"),
                        "LU" => __("Luxembourg", "yatra"),
                        "MO" => __("Macao", "yatra"),
                        "MK" => __("Macedonia, the Former Yugoslav Republic of", "yatra"),
                        "MG" => __("Madagascar", "yatra"),
                        "MW" => __("Malawi", "yatra"),
                        "MY" => __("Malaysia", "yatra"),
                        "MV" => __("Maldives", "yatra"),
                        "ML" => __("Mali", "yatra"),
                        "MT" => __("Malta", "yatra"),
                        "MH" => __("Marshall Islands", "yatra"),
                        "MQ" => __("Martinique", "yatra"),
                        "MR" => __("Mauritania", "yatra"),
                        "MU" => __("Mauritius", "yatra"),
                        "YT" => __("Mayotte", "yatra"),
                        "MX" => __("Mexico", "yatra"),
                        "FM" => __("Micronesia, Federated States of", "yatra"),
                        "MD" => __("Moldova, Republic of", "yatra"),
                        "MC" => __("Monaco", "yatra"),
                        "MN" => __("Mongolia", "yatra"),
                        "MS" => __("Montserrat", "yatra"),
                        "MA" => __("Morocco", "yatra"),
                        "MZ" => __("Mozambique", "yatra"),
                        "MM" => __("Myanmar", "yatra"),
                        "NA" => __("Namibia", "yatra"),
                        "NR" => __("Nauru", "yatra"),
                        "NP" => __("Nepal", "yatra"),
                        "NL" => __("Netherlands", "yatra"),
                        "AN" => __("Netherlands Antilles", "yatra"),
                        "NC" => __("New Caledonia", "yatra"),
                        "NZ" => __("New Zealand", "yatra"),
                        "NI" => __("Nicaragua", "yatra"),
                        "NE" => __("Niger", "yatra"),
                        "NG" => __("Nigeria", "yatra"),
                        "NU" => __("Niue", "yatra"),
                        "NF" => __("Norfolk Island", "yatra"),
                        "MP" => __("Northern Mariana Islands", "yatra"),
                        "NO" => __("Norway", "yatra"),
                        "OM" => __("Oman", "yatra"),
                        "PK" => __("Pakistan", "yatra"),
                        "PW" => __("Palau", "yatra"),
                        "PS" => __("Palestinian Territory, Occupied", "yatra"),
                        "PA" => __("Panama", "yatra"),
                        "PG" => __("Papua New Guinea", "yatra"),
                        "PY" => __("Paraguay", "yatra"),
                        "PE" => __("Peru", "yatra"),
                        "PH" => __("Philippines", "yatra"),
                        "PN" => __("Pitcairn", "yatra"),
                        "PL" => __("Poland", "yatra"),
                        "PT" => __("Portugal", "yatra"),
                        "PR" => __("Puerto Rico", "yatra"),
                        "QA" => __("Qatar", "yatra"),
                        "RE" => __("Reunion", "yatra"),
                        "RO" => __("Romania", "yatra"),
                        "RU" => __("Russian Federation", "yatra"),
                        "RW" => __("Rwanda", "yatra"),
                        "SH" => __("Saint Helena", "yatra"),
                        "KN" => __("Saint Kitts and Nevis", "yatra"),
                        "LC" => __("Saint Lucia", "yatra"),
                        "PM" => __("Saint Pierre and Miquelon", "yatra"),
                        "VC" => __("Saint Vincent and the Grenadines", "yatra"),
                        "WS" => __("Samoa", "yatra"),
                        "SM" => __("San Marino", "yatra"),
                        "ST" => __("Sao Tome and Principe", "yatra"),
                        "SA" => __("Saudi Arabia", "yatra"),
                        "SN" => __("Senegal", "yatra"),
                        "CS" => __("Serbia and Montenegro", "yatra"),
                        "SC" => __("Seychelles", "yatra"),
                        "SL" => __("Sierra Leone", "yatra"),
                        "SG" => __("Singapore", "yatra"),
                        "SK" => __("Slovakia", "yatra"),
                        "SI" => __("Slovenia", "yatra"),
                        "SB" => __("Solomon Islands", "yatra"),
                        "SO" => __("Somalia", "yatra"),
                        "ZA" => __("South Africa", "yatra"),
                        "GS" => __("South Georgia and the South Sandwich Islands", "yatra"),
                        "ES" => __("Spain", "yatra"),
                        "LK" => __("Sri Lanka", "yatra"),
                        "SD" => __("Sudan", "yatra"),
                        "SR" => __("Suriname", "yatra"),
                        "SJ" => __("Svalbard and Jan Mayen", "yatra"),
                        "SZ" => __("Swaziland", "yatra"),
                        "SE" => __("Sweden", "yatra"),
                        "CH" => __("Switzerland", "yatra"),
                        "SY" => __("Syrian Arab Republic", "yatra"),
                        "TW" => __("Taiwan, Province of China", "yatra"),
                        "TJ" => __("Tajikistan", "yatra"),
                        "TZ" => __("Tanzania, United Republic of", "yatra"),
                        "TH" => __("Thailand", "yatra"),
                        "TL" => __("Timor-Leste", "yatra"),
                        "TG" => __("Togo", "yatra"),
                        "TK" => __("Tokelau", "yatra"),
                        "TO" => __("Tonga", "yatra"),
                        "TT" => __("Trinidad and Tobago", "yatra"),
                        "TN" => __("Tunisia", "yatra"),
                        "TR" => __("Turkey", "yatra"),
                        "TM" => __("Turkmenistan", "yatra"),
                        "TC" => __("Turks and Caicos Islands", "yatra"),
                        "TV" => __("Tuvalu", "yatra"),
                        "UG" => __("Uganda", "yatra"),
                        "UA" => __("Ukraine", "yatra"),
                        "AE" => __("United Arab Emirates", "yatra"),
                        "GB" => __("United Kingdom", "yatra"),
                        "US" => __("United States", "yatra"),
                        "UM" => __("United States Minor Outlying Islands", "yatra"),
                        "UY" => __("Uruguay", "yatra"),
                        "UZ" => __("Uzbekistan", "yatra"),
                        "VU" => __("Vanuatu", "yatra"),
                        "VE" => __("Venezuela", "yatra"),
                        "VN" => __("Viet Nam", "yatra"),
                        "VG" => __("Virgin Islands, British", "yatra"),
                        "VI" => __("Virgin Islands, U.s.", "yatra"),
                        "WF" => __("Wallis and Futuna", "yatra"),
                        "EH" => __("Western Sahara", "yatra"),
                        "YE" => __("Yemen", "yatra"),
                        "ZM" => __("Zambia", "yatra"),
                        "ZW" => __("Zimbabwe", "yatra"),
                    )
                )
            );

        if (!is_array($country_key)) {

            if (!empty($country_key) && isset($countries[$country_key])) {

                return $countries[$country_key];
            }
        } else {

            $return_countries = array();

            foreach ($countries as $country_index => $country) {

                if (in_array($country_index, $country_key)) {
                    $return_countries[$country_index] = $country;
                }
            }
            return $return_countries;
        }
        return $countries;

    }

}