<?php

/**
 * @Packge     : Tourm
 * @Version    : 1.0
 * @Author     : Themeholy
 * @Author URI : https://themeforest.net/user/themeholy
 *
 */

    // Block direct access

    if( ! defined( 'ABSPATH' ) ){

        exit();

    }

/**

 * Admin Custom Login Logo

 */

function tourm_custom_login_logo() {

    $logo = ! empty( tourm_opt( 'tourm_admin_login_logo', 'url' ) ) ? tourm_opt( 'tourm_admin_login_logo', 'url' ) : '' ;

    if( isset( $logo ) && ! empty( $logo ) ){

        echo '<style type="text/css">body.login div#login h1 a { background-image:url('.esc_url( $logo ).'); }</style>';
    }
}

add_action( 'login_enqueue_scripts', 'tourm_custom_login_logo' );

/**
* Admin Custom css
*/

add_action( 'admin_enqueue_scripts', 'tourm_admin_styles' );

function tourm_admin_styles() {

  if ( ! empty( $tourm_admin_custom_css ) ) {
        $tourm_admin_custom_css = str_replace(array("\r\n", "\r", "\n", "\t", '    '), '', $tourm_admin_custom_css);
        echo '<style rel="stylesheet" id="tourm-admin-custom-css" >';
            echo esc_html( $tourm_admin_custom_css );
        echo '</style>';
    }
}

// share button code

 function tourm_social_sharing_buttons( ) {

    // Get page URL

    $URL        = get_permalink();
    $Sitetitle  = get_bloginfo('name');
    // Get page title

    $Title  = str_replace( ' ', '%20', get_the_title());

    // Construct sharing URL without using any script

    $twitterURL     = 'https://twitter.com/share?text='.esc_html( $Title ).'&url='.esc_url( $URL );
    $facebookURL    = 'https://www.facebook.com/sharer/sharer.php?u='.esc_url( $URL );
    $pinterest   = 'http://pinterest.com/pin/create/link/?url='.esc_url( $URL ).'&media='.esc_url(get_the_post_thumbnail_url()).'&description='.wp_kses_post(get_the_title());
    $linkedin       = 'https://www.linkedin.com/shareArticle?mini=true&url='.esc_url( $URL ).'&title='.esc_html( $Title );
    // Add sharing button at the end of page/page content

    $content = '';

    $content .= '<a href="'.esc_url( $facebookURL ).'" target="_blank"><i class="fab fa-facebook-f"></i></a>';
    $content .= '<a href="'. esc_url( $twitterURL ) .'" target="_blank"><i class="fab fa-twitter"></i></a>';
    $content .= '<a href="'.esc_url( $linkedin ).'" target="_blank"><i class="fab fa-linkedin-in"></i></a>';
    $content .= '<a href="'.esc_url( $pinterest ).'" target="_blank"><i class="fa-brands fa-pinterest-p"></i></a>';


    return $content;

};


//Post Reading Time Count

function tourm_estimated_reading_time() {
    global $post;
    // get the content
    $the_content = $post->post_content;
    // count the number of words
    $words = str_word_count( strip_tags( $the_content ) );
    // rounding off and deviding per 100 words per minute
    $minute = floor( $words / 100 );
    // rounding off to get the seconds
    $second = floor( $words % 100 / ( 100 / 60 ) );
    // calculate the amount of time needed to read
    $estimate = $minute . esc_html__(' Min', 'tourm') . ( $minute == 1 ? '' : 's' ) . esc_html__(' Read', 'tourm');
    // create output
    $output = $estimate;
    // return the estimate
    return $output;
}



//add SVG to allowed file uploads

function tourm_mime_types( $mimes ) {

    $mimes['svg'] = 'image/svg+xml';
    $mimes['svgz'] = 'image/svgz+xml';
    $mimes['exe'] = 'program/exe';
    $mimes['dwg'] = 'image/vnd.dwg';
    return $mimes;
}

add_filter('upload_mimes', 'tourm_mime_types');



function tourm_wp_check_filetype_and_ext( $data, $file, $filename, $mimes ) {

    $wp_filetype = wp_check_filetype( $filename, $mimes );
    $ext         = $wp_filetype['ext'];
    $type        = $wp_filetype['type'];
    $proper_filename = $data['proper_filename'];

    return compact( 'ext', 'type', 'proper_filename' );

}

add_filter( 'wp_check_filetype_and_ext', 'tourm_wp_check_filetype_and_ext', 10, 4 );

add_action( 'init','tourm_project', 0 );


function tourm_project(){

    $labels = array(

        'name'               => esc_html__( 'Projects', 'post Category general name', 'tourm' ),
        'singular_name'      => esc_html__( 'Project', 'post Category singular name', 'tourm' ),
        'menu_name'          => esc_html__( 'Projects', 'admin menu', 'tourm' ),
        'name_admin_bar'     => esc_html__( 'Project', 'add new on admin bar', 'tourm' ),
        'add_new'            => esc_html__( 'Add New', 'Project', 'tourm' ),
        'add_new_item'       => esc_html__( 'Add New Project', 'tourm' ),
        'new_item'           => esc_html__( 'New Project', 'tourm' ),
        'edit_item'          => esc_html__( 'Edit Project', 'tourm' ),
        'view_item'          => esc_html__( 'View Project', 'tourm' ),
        'all_items'          => esc_html__( 'All Projects', 'tourm' ),
        'search_items'       => esc_html__( 'Search Projects', 'tourm' ),
        'parent_item_colon'  => esc_html__( 'Parent Projects:', 'tourm' ),
        'not_found'          => esc_html__( 'No Projects found.', 'tourm' ),
        'not_found_in_trash' => esc_html__( 'No Projects found in Trash.', 'tourm' ),
    );



    $args = array(

        'labels'             => $labels,
        'description'        => esc_html__( 'Description.', 'tourm' ),
        'public'             => true,
        'publicly_queryable' => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'has_archive'        => true,
        'hierarchical'       => false,
        'menu_position'      => null,
        'show_in_rest'       => true,
        'menu_icon'          => 'dashicons-index-card',
        'supports'           => array( 'title', 'thumbnail', 'editor', 'excerpt', 'elementor' ),
        'rewrite'            => array( 'slug' => 'all-projects' ),
    );

    register_post_type( 'tourm_project', $args );

  }



/**
 * Single Template
 */

// add_filter( 'single_template', 'tourm_core_template_redirect' );

// if( ! function_exists( 'tourm_core_template_redirect' ) ){

//     function tourm_core_template_redirect( $single_template ){
//         global $post;

//         if( $post ){

//             if( $post->post_type == 'tourm_event' ){

//                 $single_template = TOURAM_CORE_PLUGIN_TEMP . 'single-tourm_event.php';

//             }
//         }

//         return $single_template;
//     }

// }


/**
 * Archive Template
 */

// add_filter( 'archive_template', 'tourm_core_template_archive' );

if( ! function_exists( 'tourm_core_template_archive' ) ){

    function tourm_core_template_archive( $archive_template ){

        global $post;


        if( $post ){

            if( $post->post_type == 'tourm_event' ){

                $archive_template = TOURAM_CORE_PLUGIN_TEMP . 'archive-tourm_event.php';
            }
        }

        return $archive_template;
    }

}

function tourm_calculate_read_time($content) {
    // Average reading speed in words per minute
    $average_reading_speed = 200;

    // Strip shortcodes and HTML tags from the content
    $clean_content = wp_strip_all_tags(strip_shortcodes($content));

    // Count the number of words in the cleaned content
    $word_count = str_word_count($clean_content);

    // Calculate the reading time in minutes
    $reading_time = ceil($word_count / $average_reading_speed);

    // Return the reading time
    return $reading_time;
}



// Add Image Size
add_image_size( 'tourm_85X85', 85, 85, true );
add_image_size( 'tourm_424X498', 424, 498, true );
add_image_size( 'tourm_420X347', 420, 347, true );
add_image_size( 'tourm_248X220', 248, 220, true );
// add_image_size( 'tourm_636X300', 636, 300, true );
// add_image_size( 'tourm_416X300', 416, 300, true );


remove_filter( 'render_block', 'wp_render_layout_support_flag', 10, 2 );
remove_filter( 'render_block', 'gutenberg_render_layout_support_flag', 10, 2 );