<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Video Widget .
 *
 */
class tourm_Video extends Widget_Base {

	public function get_name() {
		return 'tourmvideo';
	}
	public function get_title() {
		return __( 'Video Box', 'tourm' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'tourm' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'video_section',
			[
				'label' 	=> __( 'video Box', 'tourm' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		tourm_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One','Style Two' ] ); 

		


		tourm_general_fields( $this, 'video_url', 'Video Url', 'TEXT', '#' );

		$this->end_controls_section();



        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		//-------Title Style-------
		// tourm_common_style_fields( $this, 'title2', 'Title', '{{WRAPPER}} .sec-title', [ '1' ] );
	
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){

			if(!empty($settings['video_url'])){
				echo '<div class="video-box1">';
	                echo '<a href="'.esc_url( $settings['video_url'] ).'" class="play-btn style2 popup-video"><i class="fa-sharp fa-solid fa-play"></i></a>';
	            echo '</div>';
	        }
		}else{
			if(!empty($settings['video_url'])){
				echo '<div class="video-box3">';
	                echo '<a href="'.esc_url( $settings['video_url'] ).'" class="play-btn popup-video"><i class="fa-sharp fa-solid fa-play"></i></a>';
	            echo '</div>';
	        }
		}
	}
}