<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Team Widget .
 *
 */
class tourm_Team extends Widget_Base {

	public function get_name() {
		return 'tourmteam';
	}
	public function get_title() {
		return __( 'Team', 'tourm' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'tourm' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'team_section',
			[
				'label'     => __( 'Team Content', 'tourm' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		tourm_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One','Style Two','Style Three','Style Four','Style Five','Style Six','Style Seven'] );


		$fields_to_include = [ 'image' => ['Team Image'], 'title' => ['Name', 'Designation'], 'url' => ['Profile URL', 'Facebook URL', 'Twitter URL', 'Linkedin URL', 'Instagram URL','Youtube URL'] ];
		tourm_repeater_fields( $this, 'team_lists', 'Member Lists', $fields_to_include, ['1','6','7']  );




		$fields_to_include2 = [ 'image' => ['Team Image', 'Bg Image'], 'title' => ['Name', 'Designation'], 'url' => ['Profile URL', 'Facebook URL', 'Twitter URL', 'Linkedin URL', 'Instagram URL','Youtube URL'] ];
		tourm_repeater_fields( $this, 'team_lists2', 'Member Lists', $fields_to_include2, ['2','3','4','5']  );


        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		//-------Name Style-------
		tourm_common_style_fields( $this, 'name', 'Name', '{{WRAPPER}} .title', ['1','2','3','4','5','6','7'], '--black-color2' );

		//-------Designation Style-------
		tourm_common_style_fields( $this, 'desig', 'Designation', '{{WRAPPER}} .desig', ['1','2','3','4','5','6','7'], '--black-color2' );



	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){

			echo '<div class="slider-area">';
                echo '<div class="swiper th-slider teamSlider1 has-shadow" id="teamSlider1" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"4"}}}\'>';
                    echo '<div class="swiper-wrapper">';
                        
                        foreach( $settings['team_lists'] as $data ){

	                    	$target = $data['profile_url']['is_external'] ? ' target="_blank"' : '';
							$nofollow = $data['profile_url']['nofollow'] ? ' rel="nofollow"' : '';

							$f_target = $data['facebook_url']['is_external'] ? ' target="_blank"' : '';
							$f_nofollow = $data['facebook_url']['nofollow'] ? ' rel="nofollow"' : '';
							$t_target = $data['twitter_url']['is_external'] ? ' target="_blank"' : '';
							$t_nofollow = $data['twitter_url']['nofollow'] ? ' rel="nofollow"' : '';
							$l_target = $data['linkedin_url']['is_external'] ? ' target="_blank"' : '';
							$l_nofollow = $data['linkedin_url']['nofollow'] ? ' rel="nofollow"' : '';
							$i_target = $data['instagram_url']['is_external'] ? ' target="_blank"' : '';
							$i_nofollow = $data['instagram_url']['nofollow'] ? ' rel="nofollow"' : '';
							$y_target = $data['youtube_url']['is_external'] ? ' target="_blank"' : '';
							$y_nofollow = $data['youtube_url']['nofollow'] ? ' rel="nofollow"' : '';

	                        echo '<div class="swiper-slide">';
	                            echo '<div class="th-team team-box">';
	                            	if(!empty($data['team_image']['url'])){
		                                echo '<div class="team-img">';
		                                    echo tourm_img_tag( array(
												'url'   => esc_url( $data['team_image']['url']  ),
											));
		                                echo '</div>';
		                            }
	                                echo '<div class="team-content">';
	                                    echo '<div class="media-body">';
	                                    	if($data['name']){
												echo '<h3 class="box-title title"><a href="'.esc_url( $data['profile_url']['url'] ).'">'.esc_html($data['name']).'</a></h3>';
											}
											if($data['designation']){
												echo '<span class="team-desig desig">'.esc_html($data['designation']).'</span>';
											}
	                                        echo '<div class="th-social">';
	                                        	if( ! empty( $data['facebook_url']['url']) ){
													echo '<a '.wp_kses_post( $f_nofollow.$f_target ).' href="'.esc_url( $data['facebook_url']['url'] ).'"><i class="fab fa-facebook-f"></i></a>';
												}
			                                    if( ! empty( $data['twitter_url']['url']) ){
													echo '<a '.wp_kses_post( $t_nofollow.$t_target ).' href="'.esc_url( $data['twitter_url']['url'] ).'"><i class="fab fa-twitter"></i></a>';
												}
												if( ! empty( $data['linkedin_url']['url']) ){
													echo '<a '.wp_kses_post( $l_nofollow.$l_target ).' href="'.esc_url( $data['linkedin_url']['url'] ).'"><i class="fab fa-linkedin-in"></i></a>';
												}
												if( ! empty( $data['instagram_url']['url']) ){
													echo '<a '.wp_kses_post( $i_nofollow.$i_target ).' href="'.esc_url( $data['instagram_url']['url'] ).'"><i class="fab fa-instagram"></i></a>';
												}
												if( ! empty( $data['youtube_url']['url']) ){
													echo '<a '.wp_kses_post( $y_nofollow.$y_target ).' href="'.esc_url( $data['youtube_url']['url'] ).'"><i class="fab fa-youtube"></i></a>';
												}
	                                        echo '</div>';
	                                    echo '</div>';
	                                echo '</div>';
	                            echo '</div>';
	                        echo '</div>';
	                    }
                    echo '</div>';
                    echo '<div class="slider-pagination"></div>';
                echo '</div>';
            echo '</div>';
		}elseif( $settings['layout_style'] == '2' ){
			echo '<div class="slider-area arrow-wrap">';
                echo '<div class="swiper th-slider teamSlider3 has-shadow" id="teamSlider3" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"3"}}}\'>';
                    echo '<div class="swiper-wrapper">';
                    	foreach( $settings['team_lists2'] as $data ){

	                    	$target = $data['profile_url']['is_external'] ? ' target="_blank"' : '';
							$nofollow = $data['profile_url']['nofollow'] ? ' rel="nofollow"' : '';

							$f_target = $data['facebook_url']['is_external'] ? ' target="_blank"' : '';
							$f_nofollow = $data['facebook_url']['nofollow'] ? ' rel="nofollow"' : '';
							$t_target = $data['twitter_url']['is_external'] ? ' target="_blank"' : '';
							$t_nofollow = $data['twitter_url']['nofollow'] ? ' rel="nofollow"' : '';
							$l_target = $data['linkedin_url']['is_external'] ? ' target="_blank"' : '';
							$l_nofollow = $data['linkedin_url']['nofollow'] ? ' rel="nofollow"' : '';
							$i_target = $data['instagram_url']['is_external'] ? ' target="_blank"' : '';
							$i_nofollow = $data['instagram_url']['nofollow'] ? ' rel="nofollow"' : '';
							$y_target = $data['youtube_url']['is_external'] ? ' target="_blank"' : '';
							$y_nofollow = $data['youtube_url']['nofollow'] ? ' rel="nofollow"' : '';
                        
	                        echo '<div class="swiper-slide">';
	                            echo '<div class="th-team team-grid">';
	                            	if(!empty($data['bg_image']['url'])){
		                                echo '<div class="team-img">';
		                                    echo tourm_img_tag( array(
												'url'   => esc_url( $data['bg_image']['url']  ),
											));
		                                echo '</div>';
		                            }
	                                if(!empty($data['team_image']['url'])){
		                                echo '<div class="team-img2">';
		                                    echo tourm_img_tag( array(
												'url'   => esc_url( $data['team_image']['url']  ),
											));
		                                echo '</div>';
		                            }
	                                echo '<div class="team-content">';
	                                    echo '<div class="media-body">';
	                                        if($data['name']){
												echo '<h3 class="box-title title"><a href="'.esc_url( $data['profile_url']['url'] ).'">'.esc_html($data['name']).'</a></h3>';
											}
											if($data['designation']){
												echo '<span class="team-desig desig">'.esc_html($data['designation']).'</span>';
											}
	                                        echo '<div class="th-social">';
	                                            if( ! empty( $data['facebook_url']['url']) ){
													echo '<a '.wp_kses_post( $f_nofollow.$f_target ).' href="'.esc_url( $data['facebook_url']['url'] ).'"><i class="fab fa-facebook-f"></i></a>';
												}
			                                    if( ! empty( $data['twitter_url']['url']) ){
													echo '<a '.wp_kses_post( $t_nofollow.$t_target ).' href="'.esc_url( $data['twitter_url']['url'] ).'"><i class="fab fa-twitter"></i></a>';
												}
												if( ! empty( $data['linkedin_url']['url']) ){
													echo '<a '.wp_kses_post( $l_nofollow.$l_target ).' href="'.esc_url( $data['linkedin_url']['url'] ).'"><i class="fab fa-linkedin-in"></i></a>';
												}
												if( ! empty( $data['instagram_url']['url']) ){
													echo '<a '.wp_kses_post( $i_nofollow.$i_target ).' href="'.esc_url( $data['instagram_url']['url'] ).'"><i class="fab fa-instagram"></i></a>';
												}
												if( ! empty( $data['youtube_url']['url']) ){
													echo '<a '.wp_kses_post( $y_nofollow.$y_target ).' href="'.esc_url( $data['youtube_url']['url'] ).'"><i class="fab fa-youtube"></i></a>';
												}

	                                        echo '</div>';
	                                    echo '</div>';
	                                echo '</div>';
	                            echo '</div>';
	                        echo '</div>';
	                    }
                	echo '</div>';
                	echo '<div class="slider-pagination"></div>';
                echo '</div>';
	            echo '<button data-slider-prev="#teamSlider3" class="slider-arrow slider-prev"><img src="'.TOURAM_ASSETS.'/img/icon/right-arrow2.svg" alt=""></button>';
	            echo '<button data-slider-next="#teamSlider3" class="slider-arrow slider-next"><img src="'.TOURAM_ASSETS.'/img/icon/left-arrow2.svg" alt=""></button>';
	        echo '</div>';

		}elseif( $settings['layout_style'] == '3' ){
			echo '<div class="row gy-4 gx-30">';
            	foreach( $settings['team_lists2'] as $data ){

                	$target = $data['profile_url']['is_external'] ? ' target="_blank"' : '';
					$nofollow = $data['profile_url']['nofollow'] ? ' rel="nofollow"' : '';

					$f_target = $data['facebook_url']['is_external'] ? ' target="_blank"' : '';
					$f_nofollow = $data['facebook_url']['nofollow'] ? ' rel="nofollow"' : '';
					$t_target = $data['twitter_url']['is_external'] ? ' target="_blank"' : '';
					$t_nofollow = $data['twitter_url']['nofollow'] ? ' rel="nofollow"' : '';
					$l_target = $data['linkedin_url']['is_external'] ? ' target="_blank"' : '';
					$l_nofollow = $data['linkedin_url']['nofollow'] ? ' rel="nofollow"' : '';
					$i_target = $data['instagram_url']['is_external'] ? ' target="_blank"' : '';
					$i_nofollow = $data['instagram_url']['nofollow'] ? ' rel="nofollow"' : '';
					$y_target = $data['youtube_url']['is_external'] ? ' target="_blank"' : '';
					$y_nofollow = $data['youtube_url']['nofollow'] ? ' rel="nofollow"' : '';
                
                    echo '<div class="col-xl-4 col-md-6">';
                        echo '<div class="th-team team-grid">';
                        	if(!empty($data['bg_image']['url'])){
                                echo '<div class="team-img">';
                                    echo tourm_img_tag( array(
										'url'   => esc_url( $data['bg_image']['url']  ),
									));
                                echo '</div>';
                            }
                            if(!empty($data['team_image']['url'])){
                                echo '<div class="team-img2">';
                                    echo tourm_img_tag( array(
										'url'   => esc_url( $data['team_image']['url']  ),
									));
                                echo '</div>';
                            }
                            echo '<div class="team-content">';
                                echo '<div class="media-body">';
                                    if($data['name']){
										echo '<h3 class="box-title title"><a href="'.esc_url( $data['profile_url']['url'] ).'">'.esc_html($data['name']).'</a></h3>';
									}
									if($data['designation']){
										echo '<span class="team-desig desig">'.esc_html($data['designation']).'</span>';
									}
                                    echo '<div class="th-social">';
                                        if( ! empty( $data['facebook_url']['url']) ){
											echo '<a '.wp_kses_post( $f_nofollow.$f_target ).' href="'.esc_url( $data['facebook_url']['url'] ).'"><i class="fab fa-facebook-f"></i></a>';
										}
	                                    if( ! empty( $data['twitter_url']['url']) ){
											echo '<a '.wp_kses_post( $t_nofollow.$t_target ).' href="'.esc_url( $data['twitter_url']['url'] ).'"><i class="fab fa-twitter"></i></a>';
										}
										if( ! empty( $data['linkedin_url']['url']) ){
											echo '<a '.wp_kses_post( $l_nofollow.$l_target ).' href="'.esc_url( $data['linkedin_url']['url'] ).'"><i class="fab fa-linkedin-in"></i></a>';
										}
										if( ! empty( $data['instagram_url']['url']) ){
											echo '<a '.wp_kses_post( $i_nofollow.$i_target ).' href="'.esc_url( $data['instagram_url']['url'] ).'"><i class="fab fa-instagram"></i></a>';
										}
										if( ! empty( $data['youtube_url']['url']) ){
											echo '<a '.wp_kses_post( $y_nofollow.$y_target ).' href="'.esc_url( $data['youtube_url']['url'] ).'"><i class="fab fa-youtube"></i></a>';
										}

                                    echo '</div>';
                                echo '</div>';
                            echo '</div>';
                        echo '</div>';
                    echo '</div>';
                }
        	echo '</div>';
		}elseif( $settings['layout_style'] == '4' ){

        	foreach( $settings['team_lists2'] as $data ){

            	$target = $data['profile_url']['is_external'] ? ' target="_blank"' : '';
				$nofollow = $data['profile_url']['nofollow'] ? ' rel="nofollow"' : '';

				$f_target = $data['facebook_url']['is_external'] ? ' target="_blank"' : '';
				$f_nofollow = $data['facebook_url']['nofollow'] ? ' rel="nofollow"' : '';
				$t_target = $data['twitter_url']['is_external'] ? ' target="_blank"' : '';
				$t_nofollow = $data['twitter_url']['nofollow'] ? ' rel="nofollow"' : '';
				$l_target = $data['linkedin_url']['is_external'] ? ' target="_blank"' : '';
				$l_nofollow = $data['linkedin_url']['nofollow'] ? ' rel="nofollow"' : '';
				$i_target = $data['instagram_url']['is_external'] ? ' target="_blank"' : '';
				$i_nofollow = $data['instagram_url']['nofollow'] ? ' rel="nofollow"' : '';
				$y_target = $data['youtube_url']['is_external'] ? ' target="_blank"' : '';
				$y_nofollow = $data['youtube_url']['nofollow'] ? ' rel="nofollow"' : '';
            
                
                echo '<div class="th-team team-grid">';
                	if(!empty($data['bg_image']['url'])){
                        echo '<div class="team-img">';
                            echo tourm_img_tag( array(
								'url'   => esc_url( $data['bg_image']['url']  ),
							));
                        echo '</div>';
                    }
                    if(!empty($data['team_image']['url'])){
                        echo '<div class="team-img2">';
                            echo tourm_img_tag( array(
								'url'   => esc_url( $data['team_image']['url']  ),
							));
                        echo '</div>';
                    }
                    echo '<div class="team-content">';
                        echo '<div class="media-body">';
                            if($data['name']){
								echo '<h3 class="box-title title"><a href="'.esc_url( $data['profile_url']['url'] ).'">'.esc_html($data['name']).'</a></h3>';
							}
							if($data['designation']){
								echo '<span class="team-desig desig">'.esc_html($data['designation']).'</span>';
							}
                            echo '<div class="th-social">';
                                if( ! empty( $data['facebook_url']['url']) ){
									echo '<a '.wp_kses_post( $f_nofollow.$f_target ).' href="'.esc_url( $data['facebook_url']['url'] ).'"><i class="fab fa-facebook-f"></i></a>';
								}
                                if( ! empty( $data['twitter_url']['url']) ){
									echo '<a '.wp_kses_post( $t_nofollow.$t_target ).' href="'.esc_url( $data['twitter_url']['url'] ).'"><i class="fab fa-twitter"></i></a>';
								}
								if( ! empty( $data['linkedin_url']['url']) ){
									echo '<a '.wp_kses_post( $l_nofollow.$l_target ).' href="'.esc_url( $data['linkedin_url']['url'] ).'"><i class="fab fa-linkedin-in"></i></a>';
								}
								if( ! empty( $data['instagram_url']['url']) ){
									echo '<a '.wp_kses_post( $i_nofollow.$i_target ).' href="'.esc_url( $data['instagram_url']['url'] ).'"><i class="fab fa-instagram"></i></a>';
								}
								if( ! empty( $data['youtube_url']['url']) ){
									echo '<a '.wp_kses_post( $y_nofollow.$y_target ).' href="'.esc_url( $data['youtube_url']['url'] ).'"><i class="fab fa-youtube"></i></a>';
								}

                            echo '</div>';
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
                
            }
		}elseif( $settings['layout_style'] == '5' ){
			echo '<div class="slider-area teamSlider4">';
                echo '<div class="swiper th-slider has-shadow" id="teamSlider4" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"3"}}}\'>';
                    echo '<div class="swiper-wrapper">';
                        
                    	foreach( $settings['team_lists2'] as $data ){
	                        $target = $data['profile_url']['is_external'] ? ' target="_blank"' : '';
							$nofollow = $data['profile_url']['nofollow'] ? ' rel="nofollow"' : '';

							$f_target = $data['facebook_url']['is_external'] ? ' target="_blank"' : '';
							$f_nofollow = $data['facebook_url']['nofollow'] ? ' rel="nofollow"' : '';
							$t_target = $data['twitter_url']['is_external'] ? ' target="_blank"' : '';
							$t_nofollow = $data['twitter_url']['nofollow'] ? ' rel="nofollow"' : '';
							$l_target = $data['linkedin_url']['is_external'] ? ' target="_blank"' : '';
							$l_nofollow = $data['linkedin_url']['nofollow'] ? ' rel="nofollow"' : '';
							$i_target = $data['instagram_url']['is_external'] ? ' target="_blank"' : '';
							$i_nofollow = $data['instagram_url']['nofollow'] ? ' rel="nofollow"' : '';
							$y_target = $data['youtube_url']['is_external'] ? ' target="_blank"' : '';
							$y_nofollow = $data['youtube_url']['nofollow'] ? ' rel="nofollow"' : '';
	                        echo '<div class="swiper-slide">';
	                            echo '<div class="th-team team-grid style2">';
	                                if(!empty($data['bg_image']['url'])){
				                        echo '<div class="team-img">';
				                            echo tourm_img_tag( array(
												'url'   => esc_url( $data['bg_image']['url']  ),
											));
				                        echo '</div>';
				                    }
	                                if(!empty($data['team_image']['url'])){
				                        echo '<div class="team-img2">';
				                            echo tourm_img_tag( array(
												'url'   => esc_url( $data['team_image']['url']  ),
											));
				                        echo '</div>';
				                    }
	                                echo '<div class="team-content">';
	                                    echo '<div class="media-body">';
	                                        if($data['name']){
												echo '<h3 class="box-title title"><a href="'.esc_url( $data['profile_url']['url'] ).'">'.esc_html($data['name']).'</a></h3>';
											}
	                                        if($data['designation']){
												echo '<span class="team-desig desig">'.esc_html($data['designation']).'</span>';
											}


	                                        echo '<div class="th-social">';
	                                            if( ! empty( $data['facebook_url']['url']) ){
													echo '<a '.wp_kses_post( $f_nofollow.$f_target ).' href="'.esc_url( $data['facebook_url']['url'] ).'"><i class="fab fa-facebook-f"></i></a>';
												}
				                                if( ! empty( $data['twitter_url']['url']) ){
													echo '<a '.wp_kses_post( $t_nofollow.$t_target ).' href="'.esc_url( $data['twitter_url']['url'] ).'"><i class="fab fa-twitter"></i></a>';
												}
												if( ! empty( $data['linkedin_url']['url']) ){
													echo '<a '.wp_kses_post( $l_nofollow.$l_target ).' href="'.esc_url( $data['linkedin_url']['url'] ).'"><i class="fab fa-linkedin-in"></i></a>';
												}
												if( ! empty( $data['instagram_url']['url']) ){
													echo '<a '.wp_kses_post( $i_nofollow.$i_target ).' href="'.esc_url( $data['instagram_url']['url'] ).'"><i class="fab fa-instagram"></i></a>';
												}
												if( ! empty( $data['youtube_url']['url']) ){
													echo '<a '.wp_kses_post( $y_nofollow.$y_target ).' href="'.esc_url( $data['youtube_url']['url'] ).'"><i class="fab fa-youtube"></i></a>';
												}
	                                        echo '</div>';
	                                    echo '</div>';
	                                echo '</div>';
	                            echo '</div>';
	                        echo '</div>';
	                    }
                    echo '</div>';
                    echo '<div class="slider-pagination"></div>';
                echo '</div>';
                echo '<button data-slider-prev="#teamSlider4" class="slider-arrow slider-prev"><img src="'.TOURAM_ASSETS.'/img/icon/right-arrow2.svg" alt=""></button>';
                echo '<button data-slider-next="#teamSlider4" class="slider-arrow slider-next"><img src="'.TOURAM_ASSETS.'/img/icon/left-arrow2.svg" alt=""></button>';
            echo '</div>';
		}elseif( $settings['layout_style'] == '6' ){
			echo '<div class="slider-area">';
                echo '<div class="swiper th-slider teamSlider5 has-shadow" id="teamSlider5" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"4"}}}\'>';
                    echo '<div class="swiper-wrapper">';
                        
                        foreach( $settings['team_lists'] as $data ){

	                    	$target = $data['profile_url']['is_external'] ? ' target="_blank"' : '';
							$nofollow = $data['profile_url']['nofollow'] ? ' rel="nofollow"' : '';

							$f_target = $data['facebook_url']['is_external'] ? ' target="_blank"' : '';
							$f_nofollow = $data['facebook_url']['nofollow'] ? ' rel="nofollow"' : '';
							$t_target = $data['twitter_url']['is_external'] ? ' target="_blank"' : '';
							$t_nofollow = $data['twitter_url']['nofollow'] ? ' rel="nofollow"' : '';
							$l_target = $data['linkedin_url']['is_external'] ? ' target="_blank"' : '';
							$l_nofollow = $data['linkedin_url']['nofollow'] ? ' rel="nofollow"' : '';
							$i_target = $data['instagram_url']['is_external'] ? ' target="_blank"' : '';
							$i_nofollow = $data['instagram_url']['nofollow'] ? ' rel="nofollow"' : '';
							$y_target = $data['youtube_url']['is_external'] ? ' target="_blank"' : '';
							$y_nofollow = $data['youtube_url']['nofollow'] ? ' rel="nofollow"' : '';

	                        echo '<div class="swiper-slide">';
	                            echo '<div class="th-team team-box style2">';
	                            	if(!empty($data['team_image']['url'])){
		                                echo '<div class="team-img">';
		                                    echo tourm_img_tag( array(
												'url'   => esc_url( $data['team_image']['url']  ),
											));
		                                echo '</div>';
		                            }
	                                echo '<div class="team-content">';
	                                    echo '<div class="media-body">';
	                                    	if($data['name']){
												echo '<h3 class="box-title title"><a href="'.esc_url( $data['profile_url']['url'] ).'">'.esc_html($data['name']).'</a></h3>';
											}
											if($data['designation']){
												echo '<span class="team-desig desig">'.esc_html($data['designation']).'</span>';
											}
	                                        echo '<div class="th-social">';
	                                        	if( ! empty( $data['facebook_url']['url']) ){
													echo '<a '.wp_kses_post( $f_nofollow.$f_target ).' href="'.esc_url( $data['facebook_url']['url'] ).'"><i class="fab fa-facebook-f"></i></a>';
												}
			                                    if( ! empty( $data['twitter_url']['url']) ){
													echo '<a '.wp_kses_post( $t_nofollow.$t_target ).' href="'.esc_url( $data['twitter_url']['url'] ).'"><i class="fab fa-twitter"></i></a>';
												}
												if( ! empty( $data['linkedin_url']['url']) ){
													echo '<a '.wp_kses_post( $l_nofollow.$l_target ).' href="'.esc_url( $data['linkedin_url']['url'] ).'"><i class="fab fa-linkedin-in"></i></a>';
												}
												if( ! empty( $data['instagram_url']['url']) ){
													echo '<a '.wp_kses_post( $i_nofollow.$i_target ).' href="'.esc_url( $data['instagram_url']['url'] ).'"><i class="fab fa-instagram"></i></a>';
												}
												if( ! empty( $data['youtube_url']['url']) ){
													echo '<a '.wp_kses_post( $y_nofollow.$y_target ).' href="'.esc_url( $data['youtube_url']['url'] ).'"><i class="fab fa-youtube"></i></a>';
												}
	                                        echo '</div>';
	                                    echo '</div>';
	                                echo '</div>';
	                            echo '</div>';
	                        echo '</div>';
	                    }
                    echo '</div>';
                    echo '<div class="slider-pagination"></div>';
                echo '</div>';
            echo '</div>';
		}else{
			echo '<div class="slider-area">';
                echo '<div class="swiper th-slider teamSlider8 has-shadow" id="teamSlider8" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":3},"767":{"slidesPerView":"3"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"4"},"1400":{"slidesPerView":"5"}}}\'>';
                    echo '<div class="swiper-wrapper">';
                      
                    	foreach( $settings['team_lists'] as $data ){

	                    	$target = $data['profile_url']['is_external'] ? ' target="_blank"' : '';
							$nofollow = $data['profile_url']['nofollow'] ? ' rel="nofollow"' : '';

							$f_target = $data['facebook_url']['is_external'] ? ' target="_blank"' : '';
							$f_nofollow = $data['facebook_url']['nofollow'] ? ' rel="nofollow"' : '';
							$t_target = $data['twitter_url']['is_external'] ? ' target="_blank"' : '';
							$t_nofollow = $data['twitter_url']['nofollow'] ? ' rel="nofollow"' : '';
							$l_target = $data['linkedin_url']['is_external'] ? ' target="_blank"' : '';
							$l_nofollow = $data['linkedin_url']['nofollow'] ? ' rel="nofollow"' : '';
							$i_target = $data['instagram_url']['is_external'] ? ' target="_blank"' : '';
							$i_nofollow = $data['instagram_url']['nofollow'] ? ' rel="nofollow"' : '';
							$y_target = $data['youtube_url']['is_external'] ? ' target="_blank"' : '';
							$y_nofollow = $data['youtube_url']['nofollow'] ? ' rel="nofollow"' : '';
                      
	                        echo '<div class="swiper-slide">';
	                            echo '<div class="th-team team-grid2">';
	                                if(!empty($data['team_image']['url'])){
		                                echo '<div class="team-img">';
		                                    echo tourm_img_tag( array(
												'url'   => esc_url( $data['team_image']['url']  ),
											));
		                                echo '</div>';
		                            }
	                                echo '<div class="team-content">';
	                                    if($data['name']){
											echo '<h3 class="box-title title"><a href="'.esc_url( $data['profile_url']['url'] ).'">'.esc_html($data['name']).'</a></h3>';
										}
	                                    echo '<div class="th-social">';
	                                        if( ! empty( $data['facebook_url']['url']) ){
												echo '<a '.wp_kses_post( $f_nofollow.$f_target ).' href="'.esc_url( $data['facebook_url']['url'] ).'"><i class="fab fa-facebook-f"></i></a>';
											}
		                                    if( ! empty( $data['twitter_url']['url']) ){
												echo '<a '.wp_kses_post( $t_nofollow.$t_target ).' href="'.esc_url( $data['twitter_url']['url'] ).'"><i class="fab fa-twitter"></i></a>';
											}
											if( ! empty( $data['linkedin_url']['url']) ){
												echo '<a '.wp_kses_post( $l_nofollow.$l_target ).' href="'.esc_url( $data['linkedin_url']['url'] ).'"><i class="fab fa-linkedin-in"></i></a>';
											}
											if( ! empty( $data['instagram_url']['url']) ){
												echo '<a '.wp_kses_post( $i_nofollow.$i_target ).' href="'.esc_url( $data['instagram_url']['url'] ).'"><i class="fab fa-instagram"></i></a>';
											}
											if( ! empty( $data['youtube_url']['url']) ){
												echo '<a '.wp_kses_post( $y_nofollow.$y_target ).' href="'.esc_url( $data['youtube_url']['url'] ).'"><i class="fab fa-youtube"></i></a>';
											}
	                                    echo '</div>';
	                                echo '</div>';
	                            echo '</div>';
	                        echo '</div>';
	                    }
                    echo '</div>';
                    echo '<div class="slider-pagination"></div>';
                echo '</div>';
            echo '</div>';
		}
	}
}