<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Resort Widget .
 *
 */
class tourm_Resort extends Widget_Base {

	public function get_name() {
		return 'tourmResort';
	}
	public function get_title() {
		return __( 'Tourm Resorts', 'tourm' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'tourm' ];
	}

	protected function register_controls() {

		 $this->start_controls_section(
			'service_section',
			[
				'label'     => __( 'Resorts', 'tourm' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		tourm_select_field( $this, 'layout_style', 'Layout Style',[ 'Style One'] );

		tourm_general_fields( $this, 'title', 'Title', 'TEXTAREA2', 'about-sec', ['1'] );
		tourm_general_fields( $this, 'price', 'Price', 'TEXTAREA2', '<span class="currency">From $350.00</span>/per Night', ['1'] );
		tourm_general_fields( $this, 'desc', 'Description', 'TEXTAREA', 'about-sec', ['1'] );

		$fields_to_include = [ 'title' => ['Label','Information'] ];
		tourm_repeater_fields( $this, 'service_list', 'Resort Lists', $fields_to_include, ['1'] );

		tourm_general_fields( $this, 'btn_text', 'Button Text', 'TEXT', '#', ['1'] );
		tourm_general_fields( $this, 'btn_url', 'Button Url', 'URL', '#', ['1'] );


        $this->end_controls_section();

		tourm_common2_style_fields( $this, 'title2', 'Title', '{{WRAPPER}} .box-title a', ['1'] );
		tourm_common2_style_fields( $this, 'title3', 'Description', '{{WRAPPER}} .desc', ['1'] );
		tourm_button_style_fields($this, '11', 'Button Styling', '{{WRAPPER}} .th-btn .style4', ['1']);


	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){
			echo '<div class="resort-content">';
				if(!empty($settings['title'])){
	                echo '<h3 class="box-title"><a href="'.esc_url($settings['btn_url']).'">'.esc_html($settings['title']).'</a></h3>';
	            }
	            if(!empty($settings['price'])){
	                echo '<h4 class="resort-price">'.wp_kses_post($settings['price']).'</h4>';
	            }
	            if(!empty($settings['desc'])){
	                echo '<p class="resort-text desc">'.esc_html($settings['desc']).'</p>';
	            }
                echo '<div class="resort-list">';
                    echo '<ul>';
                    	foreach( $settings['service_list'] as $data ){  
	                        echo '<li><span class="title">'.esc_html($data['label']).'</span>'.esc_html($data['information']).'</li>';
	                    }

                    echo '</ul>';
                echo '</div>';
                if(!empty($settings['btn_text'])){
	                echo '<div class="resort-btn mt-40">';
	                    echo '<a href="'.esc_url($settings['btn_url']).'" class="th-btn style4 th-icon">'.esc_html($settings['btn_text']).'</a>';
	                echo '</div>';
	            }
            echo '</div>';
		}
	}
}