<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Menu Select Widget .
 *
 */
class Tourm_Menu extends Widget_Base {

	public function get_name() {
		return 'tourmmenuselect';
	}
	public function get_title() {
		return __( 'Menu Select', 'tourm' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'tourm' ];
	}

	protected function register_controls() {

		 $this->start_controls_section(
			'section_title_section',
			[
				'label'		 	=> __( 'Navigation Menu', 'tourm' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );

		tourm_select_field( $this, 'layout_style', 'Layout Style',['Style One', 'Style Two', 'Style Three'] );

		tourm_general_fields( $this, 'title', 'Title', 'TEXT', 'Title', ['3'] );

		$menus = $this->tourm_menu_select();

		if( !empty( $menus ) ){
	        $this->add_control(
				'tourm_menu_select',
				[
					'label'     	=> __( 'Select Tourm Menu', 'tourm' ),
					'type'      	=> Controls_Manager::SELECT,
					'options'   	=> $menus,
					'description' 	=> sprintf( __( 'Go to the <a href="%s" target="_blank">Menus screen</a> to manage your menus.', 'tourm' ), admin_url( 'nav-menus.php' ) ),
				]
			);
		}else {
			$this->add_control(
				'no_menu',
				[
					'type' 				=> Controls_Manager::RAW_HTML,
					'raw' 				=> '<strong>' . __( 'There are no menus in your site.', 'tourm' ) . '</strong><br>' . sprintf( __( 'Go to the <a href="%s" target="_blank">Menus screen</a> to create one.', 'tourm' ), admin_url( 'nav-menus.php?action=edit&menu=0' ) ),
					'separator' 		=> 'after',
					'content_classes' 	=> 'elementor-panel-alert elementor-panel-alert-info',
				]
			);
		}

        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		//-------Title Style-------
		tourm_common_style_fields( $this, 'title', 'Title', '{{WRAPPER}} .widget_title', ['3'] );

	}

    public function tourm_menu_select(){ 
	    $tourm_menu = wp_get_nav_menus();
	    $menu_array  = array();
		$menu_array[''] = __( 'Select A Menu', 'tourm' );
	    foreach( $tourm_menu as $menu ){
	        $menu_array[ $menu->slug ] = $menu->name;
	    }
	    return $menu_array;
	}

	protected function render() {

	$settings = $this->get_settings_for_display();

        //Menu by menu select
        $tourm_avaiable_menu   = $this->tourm_menu_select();

        if( ! $tourm_avaiable_menu ){
            return;
        }
		if( $settings['layout_style'] == '3' ){
			$args = [
				'menu' 		=> $settings['tourm_menu_select'],
				'menu_class' 	=> 'menu style2',
				'container' 	=> '',
			];
		}else{
			$args = [
				'menu' 		=> $settings['tourm_menu_select'],
				'menu_class' 	=> 'menu',
				'container' 	=> '',
			];
		}

		if( $settings['layout_style'] == '1' ){
			if( ! empty( $settings['tourm_menu_select'] ) ){
                wp_nav_menu( $args );
            } 

		}elseif( $settings['layout_style'] == '2' ){
			echo '<div class="footer-links">';
				if( ! empty( $settings['tourm_menu_select'] ) ){
					wp_nav_menu( $args );
				} 
			echo '</div>';

		}elseif( $settings['layout_style'] == '3' ){
			echo '<div class="widget widget_nav_menu footer-widget">';
				if( !empty($settings['title']) ){
					echo '<h3 class="widget_title">'.esc_html($settings['title']).'</h3>';
				}
				echo '<div class="menu-all-pages-container">';
						if( ! empty( $settings['tourm_menu_select'] ) ){
							wp_nav_menu( $args );
						} 
				echo '</div>';
            echo '</div>';
		}


	}

}