<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
/**
 *
 * Banner Widget.
 *
 */
class Tourm_Banner_V2 extends Widget_Base {

	public function get_name() {
		return 'tourmbannerv2';
	}
	public function get_title() {
		return __( 'Banner Slider v2', 'tourm' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'tourm_header_elements' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'banner_section',
			[
				'label' 	=> __( 'Banner', 'tourm' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		tourm_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One', 'Style Two', 'Style Three', 'Style Four', 'Style Five', 'Style Six', 'Style Seven' ] );


		$fields_to_include = [ 'image' => ['Thumb 1','Thumb 2'], 'title' => ['Title', 'Description'], 'btn' => ['Button Text'], 'url' => ['Button URL'] ];
		tourm_repeater_fields( $this, 'banners1', 'Banner Info', $fields_to_include, ['2'] );


		$fields_to_include2 = [ 'image' => ['Background'], 'title' => ['Title', 'Description'], 'btn' => ['Button Text 1', 'Button Text 2'], 'url' => ['Button URL 1', 'Button URL 2'] ];
		tourm_repeater_fields( $this, 'banners2', 'Banner Info', $fields_to_include2, ['3'] );


		$fields_to_includ3 = [ 'image' => ['Thumb'], 'title' => ['Heading', 'Title'], 'btn' => ['Button Text'], 'url' => ['Button URL'] ];
		tourm_repeater_fields( $this, 'banners3', 'Banner Info', $fields_to_includ3, ['5'] );


		$fields_to_includ4 = [ 'image' => ['Thumb'], 'title' => ['Title'], 'btn' => ['Button Text'], 'url' => ['Button URL'] ];
		tourm_repeater_fields( $this, 'banners4', 'Banner Info', $fields_to_includ4, ['6','7'] );


		tourm_media_fields( $this, 'bg', 'Bg Image', ['1','2','4','5'] );


		tourm_general_fields( $this, 'heading', 'Heading', 'TEXT', 'Need Help?', ['1','4'] );
		tourm_general_fields( $this, 'address', 'Address', 'TEXTAREA2', '45 New Eskaton Road, Austria', ['6'] );
		tourm_general_fields( $this, 'o_h', 'Office Hours', 'TEXTAREA2', 'Sun to Friday: 8.00 am - 7.00 pm', ['6'] );


		tourm_general_fields( $this, 'title', 'Tittle', 'TEXTAREA2', 'Need Help?', ['1','4'] );
		tourm_general_fields( $this, 'shortcode', 'Shortcode', 'TEXTAREA2', 'Need Help?', ['4'] );

		tourm_general_fields( $this, 'btn_text', 'Button Text', 'TEXT', '#', ['1', '4'] );
		tourm_general_fields( $this, 'btn_url', 'Button Url', 'URL', '#', ['1', '4'] );


		tourm_general_fields( $this, 'btn_text2', 'Button Text2', 'TEXT', '#', ['1', '4'] );
		tourm_general_fields( $this, 'btn_url2', 'Button Url2', 'URL', '#', ['1','4'] );

		tourm_media_fields( $this, 'shape', 'Shape', ['1'] );
		tourm_media_fields( $this, 'shape2', 'Shape 2', ['1'] );
		tourm_media_fields( $this, 'shape3', 'Shape 3', ['1'] );
		tourm_media_fields( $this, 'shape4', 'Shape 4', ['1'] );
		tourm_media_fields( $this, 'shape5', 'Shape 5', ['1'] );
		tourm_media_fields( $this, 'shape6', 'Shape 6', ['1'] );

		tourm_general_fields( $this, 'scroll_text', 'Scroll Text', 'TEXT', ' Scroll  Down', ['7'] );
		tourm_general_fields( $this, 'idss', 'Scroll ID', 'TEXT', 'About', ['7'] );


		$this->end_controls_section();


		tourm_common_style_fields($this, 'subtitle', 'Subtitle', '{{WRAPPER}} .banner_subtitle', ['1']);

		//-------Title Style-------
		tourm_common_style_fields($this, 'title', 'Heading', '{{WRAPPER}} .heading', ['1','4','5']);
		tourm_common_style_fields($this, 'title2', 'Title', '{{WRAPPER}} .h_title', ['1','3','4','5','6']);
		tourm_common_style_fields($this, 'title3', 'Description', '{{WRAPPER}} .desc', ['3']);
		tourm_button_style_fields($this, '10', 'Button Styling', '{{WRAPPER}} .th-btn .style3', ['1']);
		tourm_button_style_fields($this, '11', 'Button Styling', '{{WRAPPER}} .th-btn', ['1','2','3','4','5']);
		tourm_button_style_fields($this, '12', 'Button Styling', '{{WRAPPER}} .th-btn .style2', ['1','2','3','4']);

    }

	protected function render() {

    $settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){
			$bg = $settings['bg']['url'] ?  $settings['bg']['url'] : '#';

			echo '<div class="th-hero-wrapper bg-bottom-center hero-4" id="hero" data-bg-src="'.esc_url( $bg ).'">';
		        echo '<div class="container">';
		            echo '<div class="hero-style4 text-center">';
		            	if(!empty( $settings['heading'] )){
			                echo '<span class="sub-title style1 heading">'.esc_html( $settings['heading'] ).'</span>';
			            }
			            if(!empty( $settings['title'] )){
			                echo '<h1 class="hero-title h_title">'.esc_html( $settings['title'] ).'</h1>';
			            }
		                echo '<div class="btn-group">';
		                	if(!empty($settings['btn_text'])){
	                            echo '<a href="'.esc_url($settings['btn_url']).'" class="th-btn th-icon">'.esc_html($settings['btn_text']).'</a>';
	                        }
	                        if(!empty($settings['btn_text2'])){
	                            echo '<a href="'.esc_url($settings['btn_url2']).'" class="th-btn style3 th-icon">'.esc_html($settings['btn_text2']).'</a>';
	                        }
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		        if(!empty(  $settings['shape']['url'] )){
                    echo '<div class="shape-mockup shape1" data-top="12%" data-left="9%">';
                        echo '<img src="'.esc_url( $settings['shape']['url'] ).'" alt="">';
                    echo '</div>';
                }
                if(!empty(  $settings['shape2']['url'] )){
                    echo '<div class="shape-mockup shape2" data-top="22%" data-left="6%">';
                        echo '<img src="'.esc_url( $settings['shape2']['url'] ).'" alt="">';
                    echo '</div>';
                }
                if(!empty(  $settings['shape3']['url'] )){
                    echo '<div class="shape-mockup shape3" data-top="14%" data-left="2%">';
                        echo '<img src="'.esc_url( $settings['shape3']['url'] ).'" alt="">';
                    echo '</div>';
                }

                if(!empty(  $settings['shape4']['url'] )){
                    echo '<div class="shape-mockup spin d-none d-lg-block" data-top="10%" data-right="6%">';
                        echo '<img src="'.esc_url( $settings['shape4']['url'] ).'" alt="">';
                    echo '</div>';
                }
                if(!empty(  $settings['shape5']['url'] )){
                    echo '<div class="shape-mockup d-none d-xl-block" data-top="35%" data-right="0%">';
                        echo '<img src="'.esc_url( $settings['shape5']['url'] ).'" alt="">';
                    echo '</div>';
                }
                if(!empty(  $settings['shape6']['url'] )){
                    echo '<div class="shape-mockup spin d-none d-lg-block" data-top="28%" data-right="15%">';
                        echo '<img src="'.esc_url( $settings['shape6']['url'] ).'" alt="">';
                    echo '</div>';
                }
		    echo '</div>';
		}elseif( $settings['layout_style'] == '2' ){

			$bg = $settings['bg']['url'] ?  $settings['bg']['url'] : '#';
			echo '<div class="th-hero-wrapper hero-5" id="hero" data-bg-src="'.esc_url( $bg ).'">';
		        echo '<div class="swiper th-slider hero-slider-5" id="heroSlide1" data-slider-options=\'{"effect":"fade","menu": ["", "", ""],"heroSlide1": {"swiper-container": {"pagination": {"el": ".swiper-pagination", "clickable": true }}}}\'>';
		            echo '<div class="swiper-wrapper">';
		                foreach( $settings['banners1'] as  $data ){ 
			                echo '<div class="swiper-slide">';
			                    echo '<div class="hero-inner">';
			                        echo '<div class="container">';
			                            echo '<div class="hero-style5">';
			                            	if(!empty( $data['title'] )){
				                                echo '<h1 class="hero-title text-white h_title" data-ani="slideinleft" data-ani-delay="0.4s">'.esc_html( $data['title'] ).'</h1>';
				                            }
				                            if(!empty( $data['description'] )){
				                                echo '<p class="hero-text" data-ani="slideinleft" data-ani-delay="0.4s">'.esc_html( $data['description'] ).'</p>';
				                            }
				                            if(!empty($data['button_text'])){  
				                                echo '<div class="btn-group" data-ani="slideinup" data-ani-delay="0.6s">';
				                                    echo '<a href="'.esc_url( $data['button_url']['url'] ).'" class="th-btn style2 th-icon">'.esc_html($data['button_text']).'</a>';
				                                echo '</div>';
				                            }
			                            echo '</div>';
			                        echo '</div>';
			                        echo '<div class="th-hero-image">';
			                        	if(!empty(  $data['thumb_1']['url'] )){
				                            echo '<div class="hero-img" data-ani="slideinleft" data-ani-delay="0.8s">';
				                                echo '<img src=" '.esc_url( $data['thumb_1']['url'] ).'" alt="">';
				                            echo '</div>';
				                        }
				                        if(!empty(  $data['thumb_2']['url'] )){
				                            echo '<div class="hero-img2" data-ani="slideinright" data-ani-delay="0.9s">';
				                                echo '<img src=" '.esc_url( $data['thumb_2']['url'] ).'" alt="">';
				                            echo '</div>';
				                        }
			                        echo '</div>';
			                    echo '</div>';
			                echo '</div>';
			            }
		            echo '</div>';
		            echo '<div class="th-swiper-custom">';
		                echo '<button data-slider-prev="#heroSlide1" class="slider-arrow slider-prev"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/right-arrow.svg" alt=""></button>';
		                echo '<div class="slider-pagination"></div>';
		                echo '<button data-slider-next="#heroSlide1" class="slider-arrow slider-next"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/left-arrow.svg" alt=""></button>';
		            echo '</div>';

		        echo '</div>';
		    echo '</div>';
		}elseif( $settings['layout_style'] == '3' ){
			echo '<div class="hero-6" id="hero">';
		        echo '<div class="swiper hero-slider-6" id="heroSlide6">';
		            echo '<div class="swiper-wrapper">';

		            	foreach( $settings['banners2'] as  $data ){ 
			                echo '<div class="swiper-slide">';
			                    echo '<div class="hero-inner">';
			                    	if(!empty(  $data['background']['url'] )){
				                        echo '<div class="th-hero-bg" data-bg-src="'.esc_url( $data['background']['url'] ).'">';
				                        echo '</div>';
				                    }
			                        echo '<div class="container">';
			                            echo '<div class="hero-style6">';
			                            	if(!empty( $data['title'] )){
				                                echo '<h1 class="hero-title h_title" data-ani="slideinup" data-ani-delay="0.2s">'.esc_html( $data['title'] ).'</h1>';
				                            }
				                            if(!empty( $data['description'] )){
				                                echo '<p class="hero-text desc" data-ani="slideinup" data-ani-delay="0.4s">'.esc_html( $data['description'] ).'</p>';
				                            }
			                                echo '<div class="btn-group" data-ani="slideinup" data-ani-delay="0.6s">';
			                                	if(!empty($data['button_text_1'])){  
				                                    echo '<a href="'.esc_url( $data['button_url_1']['url'] ).'" class="th-btn th-icon">'.esc_html($data['button_text_1']).'</a>';
				                                }
				                                if(!empty($data['button_text_2'])){  
				                                    echo '<a href="'.esc_url( $data['button_url_2']['url'] ).'" class="th-btn style2 th-icon">'.esc_html($data['button_text_2']).'</a>';
				                                }
			                                echo '</div>';
			                            echo '</div>';
			                        echo '</div>';
			                    echo '</div>';
			                echo '</div>';
			            }
		            echo '</div>';
		        echo '</div>';
		        echo '<div class="hero6-wrapper">';
		            echo '<div class="swiper hero6Thumbs">';
		                echo '<div class="swiper-wrapper">';

		                    foreach( $settings['banners2'] as  $data ){ 
			                    echo '<div class="swiper-slide">';
			                        echo '<div class="hero-inner">';
			                            echo '<div class="hero6-card">';
			                                echo '<div class="hero-img">';
			                                	if(!empty(  $data['background']['url'] )){
				                                    echo '<img src="'.esc_url( $data['background']['url'] ).'" alt="">';
				                                }
			                                echo '</div>';
			                            echo '</div>';
			                        echo '</div>';
			                    echo '</div>';
			                }
		                    


		                echo '</div>';
		                echo '<div class="hero6-swiper-custom">';
		                    echo '<div class="swiper-pagination"></div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		        echo '<div class="th-swiper-custom">';
		            echo '<button data-slider-prev="#heroSlide6" class="slider-arrow slider-prev"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/right-arrow.svg" alt=""></button>';
		            echo '<button data-slider-next="#heroSlide6" class="slider-arrow slider-next"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/left-arrow.svg" alt=""></button>';
		        echo '</div>';
		    echo '</div>';
		}elseif( $settings['layout_style'] == '4' ){
			$bg = $settings['bg']['url'] ?  $settings['bg']['url'] : '#';

			echo '<div class="th-hero-wrapper hero-7" id="hero" data-bg-src="'.esc_url( $bg ).'">';
		        echo '<div class="container">';
		            echo '<div class="row align-items-center">';
		                echo '<div class="col-lg-7 col-xl-8">';
		                    echo '<div class="hero-style7">';
		                    	if(!empty( $settings['heading'] )){
					                echo '<span class="sub-title style1 heading">'.esc_html( $settings['heading'] ).'</span>';
					            }
					            if(!empty( $settings['title'] )){
					                echo '<h1 class="hero-title h_title">'.esc_html( $settings['title'] ).'</h1>';
					            }
		                        echo '<div class="btn-group">';
		                        	if(!empty($settings['btn_text'])){  
	                                    echo '<a href="'.esc_url( $settings['btn_url'] ).'" class="th-btn th-icon">'.esc_html($settings['btn_text']).'</a>';
	                                }
	                                if(!empty($settings['btn_text2'])){  
	                                    echo '<a href="'.esc_url( $settings['btn_url2'] ).'" class="th-btn style2 th-icon">'.esc_html($settings['btn_text2']).'</a>';
	                                }
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		                echo '<div class="col-lg-5 col-xl-4">';
		                    if( !empty( $settings['shortcode']) ){
                                echo do_shortcode( $settings['shortcode'] );
                            }  
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}elseif( $settings['layout_style'] == '5' ){
			$bg = $settings['bg']['url'] ?  $settings['bg']['url'] : '#';
			echo '<div class="th-hero-wrapper hero-8" id="hero" data-bg-src="'.esc_url( $bg ).'">';
		        echo '<div class="swiper th-slider hero-slider-5" id="heroSlide1" data-slider-options=\'{"effect":"fade","menu": ["", "", ""],"heroSlide1": {"swiper-container": {"pagination": {"el": ".swiper-pagination", "clickable": true }}}}\'>';
		            echo '<div class="swiper-wrapper">';

		            	foreach( $settings['banners3'] as  $data ){ 
			                echo '<div class="swiper-slide">';
			                    echo '<div class="hero-inner">';
			                        echo '<div class="container">';
			                            echo '<div class="hero-style8">';
			                            	if(!empty( $data['heading'] )){
				                                echo '<span class="sub-title style1 heading " data-ani="slideinleft" data-ani-delay="0.4s">'.esc_html( $data['heading'] ).'</span>';
				                            }
			                                if(!empty( $data['title'] )){
				                                echo '<h1 class="hero-title h_title" data-ani="slideinleft" data-ani-delay="0.5s">'.esc_html( $data['title'] ).' </h1>';
				                            }
				                            if(!empty($data['button_text'])){  
				                                echo '<div class="btn-group" data-ani="slideinleft" data-ani-delay="0.6s">';
				                                    echo '<a href="'.esc_url( $data['button_url']['url'] ).'" class="th-btn style1 th-icon">'.esc_html( $data['button_text'] ).'</a>';
				                                echo '</div>';
				                            }
			                            echo '</div>';
			                        echo '</div>';
			                        if(!empty(  $data['thumb']['url'] )){
				                        echo '<div class="th-hero-image">';
				                            echo '<div class="hero-img" data-ani="slideinright" data-ani-delay="0.8s">';
				                                echo '<img src="'.esc_url( $data['thumb']['url'] ).'" alt="">';
				                            echo '</div>';
				                        echo '</div>';
				                    }
			                    echo '</div>';
			                echo '</div>';
			            }
		                
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}elseif( $settings['layout_style'] == '6' ){
			echo '<div class="hero-9" id="hero">';
		        echo '<div class="slider-wrap">';
		            echo '<div class="swiper th-slider has-shadow" id="heroSlider9" data-slider-options=\'{"effect":"fade","paginationType":"fraction","breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"1"},"992":{"slidesPerView":"1"},"1200":{"slidesPerView":"1"},"1300":{"slidesPerView":"1"}}}\'>';
		                echo '<div class="swiper-wrapper">';

		                	foreach( $settings['banners4'] as  $data ){ 
			                    echo '<div class="swiper-slide">';
			                        echo '<div class="hero-inner">';
			                        	if(!empty(  $data['thumb']['url'] )){
				                            echo '<div class="th-hero-bg" data-bg-src="'.esc_url( $data['thumb']['url'] ).'"></div>';
				                        }
			                            echo '<div class="container">';
			                                echo '<div class="hero-style9">';
			                                	if(!empty( $data['title'] )){
				                                    echo '<h1 class="hero-title h_title" data-ani="slideinup" data-ani-delay="0.2s">'.esc_html( $data['title'] ).' </h1>';
				                                }
				                                if(!empty($data['button_text'])){  
				                                    echo '<div class="btn-group" data-ani="slideinup" data-ani-delay="0.6s">';
				                                        echo '<a href="'.esc_url( $data['button_url']['url'] ).'" class="th-btn style2 th-icon">'.esc_html( $data['button_text'] ).'</a>';
				                                    echo '</div>';
				                                }
			                                echo '</div>';
			                            echo '</div>';
			                        echo '</div>';
			                    echo '</div>';
			                }
		                echo '</div>';
		            echo '</div>';
		            echo '<div class="slider-controller">';
		                echo '<button data-slider-prev="#heroSlider9" class="hero-arrow slider-prev"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/hero-arrow-left.svg" alt=""></button>';
		                echo '<div class="slider-pagination" data-slider-id="#heroSlider9"></div>';
		                echo '<button data-slider-next="#heroSlider9" class="hero-arrow slider-next"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/hero-arrow-right.svg" alt=""></button>';
		            echo '</div>';
		        echo '</div>';

		        echo '<div class="hero9-wrapp">';
		            echo '<div class="container">';
		                echo '<div class="row gx-0">';
		                    echo '<div class="col-lg-8">';
		                        echo '<div class="hero-booking style2">';
		                            echo '<div class="booking-form style5">';
		                                echo do_shortcode( '[Wte_Advanced_Search_Form]' ); 
		                            echo '</div>';
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		        echo '<div class="hero-left">';
		            echo '<div class="header-links">';
		                echo '<ul>';
		                	if(!empty( $settings['address'] )){
			                    echo '<li class="d-none d-xl-inline-block"><i class="fa-sharp fa-regular  fa-location-dot"></i>';
			                        echo '<span>'.esc_html( $settings['address'] ).' </span>';
			                    echo '</li>';
			                }
			                if(!empty( $settings['o_h'] )){
			                    echo '<li class="d-none d-xl-inline-block"><i class="fa-regular fa-clock"></i>';
			                        echo '<span>'.esc_html( $settings['o_h'] ).'</span>';
			                    echo '</li>';
			                }
		                echo '</ul>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}else{
			echo '<div class="hero-10" id="hero">'; 
		        echo '<div class="swiper hero-slider-10" id="heroSlide10">'; 
		            echo '<div class="swiper-wrapper">'; 
		            	foreach( $settings['banners4'] as  $data ){ 
			                echo '<div class="swiper-slide">'; 
			                    echo '<div class="hero-inner">'; 
			                    	if(!empty(  $data['thumb']['url'] )){
				                        echo '<div class="th-hero-bg" data-bg-src="'.esc_url( $data['thumb']['url'] ).'"></div>'; 
				                    }

			                        echo '<div class="container">'; 
			                            echo '<div class="hero-style10">'; 
			                            	if(!empty( $data['title'] )){
				                                echo '<h1 class="hero-title" data-ani="slideinup" data-ani-delay="0.4s">'.wp_kses_post( $data['title'] ).'</h1>'; 
				                            }
				                            if(!empty($data['button_text'])){ 
				                                echo '<div class="btn-group" data-ani="slideinup" data-ani-delay="0.6s">'; 
				                                    echo '<a href="'.esc_url( $data['button_url']['url'] ).'" class="th-btn style2 th-icon">'.esc_html( $data['button_text'] ).'</a>'; 
				                                echo '</div>'; 
				                            }
			                            echo '</div>'; 
			                        echo '</div>'; 
			                    echo '</div>'; 
			                echo '</div>';
			            }
		           echo ' </div>'; 
		        echo '</div>'; 
		        echo '<div class="hero3-wrapper">'; 
		            echo '<div class="container">'; 
		                echo '<div class="row justify-content-center align-items-end flex-row-reverse">'; 
		                    echo '<div class="col-lg-4">'; 
		                        echo '<div class="hero10-swiper-custom">'; 
		                            echo '<button data-slider-prev="#heroSlide3" class="swiper-button-next"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/hero-arrow-right.svg" alt=""></button>'; 
		                            echo '<div class="swiper-pagination"></div>'; 
		                            echo '<button data-slider-next="#heroSlide3" class="swiper-button-prev"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/hero-arrow-left.svg" alt=""></button>'; 

		                        echo '</div>'; 
		                        echo '<div class="swiper hero10Thumbs" id="heroSlide11">'; 
		                            echo '<div class="swiper-wrapper">'; 

		                            	foreach( $settings['banners4'] as  $data ){ 
		                            		if(!empty(  $data['thumb']['url'] )){
				                                echo '<div class="swiper-slide">'; 
				                                    echo '<div class="hero-inner">'; 
				                                        echo '<div class="hero10-card">'; 
				                                            echo '<div class="hero-img">'; 
				                                                echo '<img src="'.esc_url( $data['thumb']['url'] ).'" alt="">'; 
				                                            echo '</div>'; 
				                                        echo '</div>'; 
				                                    echo '</div>'; 
				                                echo '</div>'; 
				                            }
			                            }
		                                

		                            echo '</div>'; 
		                        echo '</div>'; 
		                    echo '</div>'; 
		                    echo '<div class="col-lg-8">'; 
		                        echo '<div class="hero-booking style2 booking">'; 
		                            
		                        echo do_shortcode( '[Wte_Advanced_Search_Form]' ); 

		                        echo '</div>'; 
		                    echo '</div>'; 
		                echo '</div>'; 
		            echo '</div>'; 
		        echo '</div>'; 
		        if( !empty( $settings['idss'] ) ){
			        echo '<div class="scroll-down">'; 
			            echo '<a href="'.esc_url( $settings['idss'] ).'" class="scroll-wrap"><span><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/down-arrow.svg" alt=""></span>'.esc_html($settings['scroll_text']).'</a>'; 
			        echo '</div>'; 
			    }
		    echo '</div>'; 
		}
	}
}