<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
/**
 *
 * Image Widget .
 *
 */
class Tourm_Image extends Widget_Base {

	public function get_name() {
		return 'tourmimage';
	}
	public function get_title() {
		return __( 'Image', 'tourm' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'tourm' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'image_section',
			[
				'label' 	=> __( 'Image', 'tourm' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		tourm_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One', 'Style Two', 'Style Three', 'Style Four', 'Style Five', 'Style Six', 'Style Seven', 'Style Eight', 'Style Nine', 'Style Ten', 'Style Eleven', 'Style Twelve'] );

		tourm_media_fields( $this, 'image1', 'Choose Image', ['1', '2', '3','4','5','6','7','8','9','10','11','12'] );
		tourm_media_fields( $this, 'image2', 'Choose Image', ['1', '2', '3','4','5','6','7','8','9']);
		tourm_media_fields( $this, 'image3', 'Choose Image', ['1', '2','6','8','9']);
		tourm_media_fields( $this, 'image4', 'Choose Image', ['8','9']);
		tourm_general_fields( $this, 'url', 'Video Url', 'TEXTAREA2', '#', [ '3','4'] );
		tourm_general_fields( $this, 'title', 'Title', 'TEXTAREA2', 'See a tour location', [ '10' ] );

		// tourm_media_fields( $this, 'image2', 'Choose Image', ['1', '4', '5'] );
		// tourm_media_fields( $this, 'image3', 'Choose Image', ['4', '5'] );
		// tourm_general_fields( $this, 'desig', 'Designatin', 'TEXTAREA2', 'Founder of Konta', ['5'] );

       $this->end_controls_section();

      	//---------------------------------------
			//Style Section Start
		//---------------------------------------

		//-------Title Style-------
		// tourm_common_style_fields( $this, 'num', 'Number', '{{WRAPPER}} .num', ['1'] );
		// tourm_common_style_fields( $this, 'title', 'Title', '{{WRAPPER}} .title', ['1'] );

	}

	protected function render() {

        $settings = $this->get_settings_for_display();
       
		if( $settings['layout_style'] == '1' ){
			echo '<div class="img-box1">';
				if(!empty($settings['image1']['url'])){
	                echo '<div class="img1">';
	                    echo tourm_img_tag( array(
							'url'   => esc_url( $settings['image1']['url'] ),
						));
	                echo '</div>';
	            }
	            if(!empty($settings['image2']['url'])){
	                echo '<div class="img2">';
	                    echo tourm_img_tag( array(
							'url'   => esc_url( $settings['image2']['url'] ),
						));
	                echo '</div>';
	            }
	            if(!empty($settings['image3']['url'])){
	                echo '<div class="img3">';
	                    echo tourm_img_tag( array(
							'url'   => esc_url( $settings['image3']['url'] ),
						));
	                echo '</div>';
	            }

            echo '</div>';
			
		}elseif( $settings['layout_style'] == '2' ){
			echo '<div class="img-box3">';
				if(!empty($settings['image1']['url'])){
	                echo '<div class="img1">';
	                    echo tourm_img_tag( array(
							'url'   => esc_url( $settings['image1']['url'] ),
						));
	                echo '</div>';
	            }
	            if(!empty($settings['image2']['url'])){
	                echo '<div class="img2">';
	                    echo tourm_img_tag( array(
							'url'   => esc_url( $settings['image2']['url'] ),
						));
	                echo '</div>';
	            }
	            if(!empty($settings['image3']['url'])){
	                echo '<div class="img3 movingX">';
	                    echo tourm_img_tag( array(
							'url'   => esc_url( $settings['image3']['url'] ),
						));
	                echo '</div>';
	            }
            echo '</div>';
		}elseif( $settings['layout_style'] == '3' ){
			echo '<div class="img-box2">';
				if(!empty($settings['image1']['url'])){
	                echo '<div class="img1">';
	                    echo tourm_img_tag( array(
							'url'   => esc_url( $settings['image1']['url'] ),
						));
	                echo '</div>';
	            }
	            if(!empty($settings['image2']['url'])){
	                echo '<div class="img2">';
	                    echo tourm_img_tag( array(
							'url'   => esc_url( $settings['image2']['url'] ),
						));
						if(!empty( $settings['url'] )){
		                    echo '<a href="'.esc_url( $settings['url'] ).'" class="play-btn popup-video"><i class="fa-sharp fa-solid fa-play"></i></a>';
		                }
	                echo '</div>';
	            }
            echo '</div>';
		}elseif( $settings['layout_style'] == '4' ){
			echo '<div class="img-box4 space-bottom">';
				if(!empty($settings['image1']['url'])){
	                echo '<div class="img1">';
	                    echo tourm_img_tag( array(
							'url'   => esc_url( $settings['image1']['url'] ),
						));
	                echo '</div>';
	            }
                echo '<div class="img2">';
                	if(!empty($settings['image2']['url'])){
	                    echo tourm_img_tag( array(
							'url'   => esc_url( $settings['image2']['url'] ),
						));
	                }
	                if(!empty( $settings['url'] )){
	                    echo '<a href="'.esc_url( $settings['url'] ).'" class="play-btn popup-video"><i class="fa-sharp fa-solid fa-play"></i></a>';
	                }
                echo '</div>';
            echo '</div>';
		}elseif( $settings['layout_style'] == '5' ){
			echo '<div class="testi-image-wrapp">';
				if(!empty($settings['image1']['url'])){
	                echo '<div class="testi-img">';
	                    echo tourm_img_tag( array(
							'url'   => esc_url( $settings['image1']['url'] ),
						));
	                echo '</div>';
	            }
	            if(!empty($settings['image2']['url'])){
	                echo '<div class="testi-img style2">';
	                    echo tourm_img_tag( array(
							'url'   => esc_url( $settings['image2']['url'] ),
						));
	                echo '</div>';
	            }

            echo '</div>';
		}elseif( $settings['layout_style'] == '6' ){
			echo '<div class="img-box6">';
                if(!empty($settings['image1']['url'])){
	                echo '<div class="img1">';
	                    echo tourm_img_tag( array(
							'url'   => esc_url( $settings['image1']['url'] ),
						));
	                echo '</div>';
	            }
                if(!empty($settings['image2']['url'])){
	                echo '<div class="img2">';
	                    echo tourm_img_tag( array(
							'url'   => esc_url( $settings['image2']['url'] ),
						));
	                echo '</div>';
	            }
               	if(!empty($settings['image3']['url'])){
	                echo '<div class="img3">';
	                    echo tourm_img_tag( array(
							'url'   => esc_url( $settings['image3']['url'] ),
						));
	                echo '</div>';
	            }
            echo '</div>';
		}elseif( $settings['layout_style'] == '7' ){
			echo '<div class="img-box7">';
				if(!empty($settings['image1']['url'])){
	                echo '<div class="img1 global-img">';
	                    echo tourm_img_tag( array(
							'url'   => esc_url( $settings['image1']['url'] ),
						));
	                echo '</div>';
	            }
	            if(!empty($settings['image2']['url'])){
	                echo '<div class="img2 global-img">';
	                    echo tourm_img_tag( array(
							'url'   => esc_url( $settings['image2']['url'] ),
						));
	                echo '</div>';
	            }
	        echo '</div>';
		}elseif( $settings['layout_style'] == '8' ){
			echo '<div class="choose-wrapp">';
				if(!empty($settings['image1']['url'])){
	                echo '<div class="img1 global-img">';
	                    echo tourm_img_tag( array(
							'url'   => esc_url( $settings['image1']['url'] ),
						));
	                echo '</div>';
	            }
	            if(!empty($settings['image2']['url'])){
	                echo '<div class="img1 global-img">';
	                    echo tourm_img_tag( array(
							'url'   => esc_url( $settings['image2']['url'] ),
						));
	                echo '</div>';
	            }
	            if(!empty($settings['image3']['url'])){
	                echo '<div class="img1 global-img">';
	                    echo tourm_img_tag( array(
							'url'   => esc_url( $settings['image3']['url'] ),
						));
	                echo '</div>';
	            }
	            if(!empty($settings['image4']['url'])){
	                echo '<div class="img1 global-img">';
	                    echo tourm_img_tag( array(
							'url'   => esc_url( $settings['image4']['url'] ),
						));
	                echo '</div>';
	            }
	        echo '</div>';
		}elseif( $settings['layout_style'] == '9' ){
			echo '<div class="testi-image-wrapp2">';
				if(!empty($settings['image1']['url'])){
	                echo '<div class="testi-img" data-mask-src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/testi_shape_1.png">';
	                    echo tourm_img_tag( array(
							'url'   => esc_url( $settings['image1']['url'] ),
						));
	                echo '</div>';
	            }
	            if(!empty($settings['image2']['url'])){
	                echo '<div class="testi-shape2">';
	                    echo tourm_img_tag( array(
							'url'   => esc_url( $settings['image2']['url'] ),
						));
	                echo '</div>';
	            }
	            if(!empty($settings['image3']['url'])){
	                echo '<div class="testi-img2">';
	                    echo tourm_img_tag( array(
							'url'   => esc_url( $settings['image3']['url'] ),
						));
	                echo '</div>';
	            }
	            if(!empty($settings['image4']['url'])){
	                echo '<div class="testi-shape">';
	                    echo tourm_img_tag( array(
							'url'   => esc_url( $settings['image4']['url'] ),
						));
	                echo '</div>';
	            }
            echo '</div>';
		}elseif( $settings['layout_style'] == '10' ){
			echo '<div class="about-item2">';
                echo '<div class="img1">';
                	if(!empty($settings['image1']['url'])){
	                    echo tourm_img_tag( array(
							'url'   => esc_url( $settings['image1']['url'] ),
						));
	                    echo '<a href="'.esc_url( $settings['image1']['url'] ).'" class="icon-btn popup-image"><i class="fa-solid fa-arrow-down-left-and-arrow-up-right-to-center"></i></a>';
	                }
                echo '</div>';
                if(!empty( $settings['title'] )){
	                echo '<div class="box-content">';
	                    echo '<h3 class="box-title">'.esc_html( $settings['title'] ).'</h3>';
	                echo '</div>';
	            }
            echo '</div>';
		}elseif( $settings['layout_style'] == '11' ){
			echo '<div class="img-box10">';
				if(!empty($settings['image1']['url'])){
	                echo '<div class="img1">';
	                    echo tourm_img_tag( array(
							'url'   => esc_url( $settings['image1']['url'] ),
						));
	                echo '</div>';
	            }
                echo '<div class="about-shape2"></div>';
            echo '</div>';
		}else{
			if(!empty($settings['image1']['url'])){
				echo '<div class="img-box2">';
	                echo '<div class="img1">';
	                    echo tourm_img_tag( array(
							'url'   => esc_url( $settings['image1']['url'] ),
						));
	                echo '</div>';
	            echo '</div>';
	        }
		}
	}
}