<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Border;
/**
 *
 * Brand Logo Widget .
 *
 */
class tourm_Slider_Image extends Widget_Base {

	public function get_name() {
		return 'tourmsliderimage';
	}
	public function get_title() {
		return __( 'Tourm Image Gallery', 'tourm' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'tourm' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'client_logo_section',
			[
				'label' 	=> __( 'Slider Image', 'tourm' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		tourm_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One', 'Style Two', 'Style Three', 'Style Four', 'Style Five', 'Style Six', 'Style Seven', 'Style Eight'] );

		tourm_media_fields( $this, 'image1', 'Choose Image',[ '1', '2','3'] );
		tourm_media_fields( $this, 'image2', 'Choose Image',[ '1', '2','3']);
		tourm_media_fields( $this, 'image3', 'Choose Image',[ '1', '2','3']);
		tourm_media_fields( $this, 'image4', 'Choose Image',[ '1', '2','3']);
		tourm_media_fields( $this, 'image5', 'Choose Image',[ '1', '2','3']);
		tourm_media_fields( $this, 'image6', 'Choose Image',[ '1', '2','3']);
		tourm_media_fields( $this, 'image7', 'Choose Image',[ '1']);

		tourm_general_fields( $this, 'title', 'Title', 'TEXT', 'Title', [ '5' ] );
		// tourm_general_fields( $this, 'subtitle', 'Subtitle', 'TEXT', 'Subtitle', [ '3' ] );
		// tourm_general_fields( $this, 'desc', 'Description', 'TEXT', 'Description', [ '3' ] );

		// tourm_general_fields( $this, 'url', 'Video Url', 'TEXT', '#', [ '1' ] );


		$fields_to_include = [ 'image' => ['Slider Image'] ];
		tourm_repeater_fields( $this, 'logos', 'Slider Images', $fields_to_include, ['4','5','6','8'] );


		$fields_to_include2 = [ 'image' => ['Slider Image'] ,'title' => ['Url']];
		tourm_repeater_fields( $this, 'logos2', 'Slider Images', $fields_to_include2, ['7'] );

		// tourm_general_fields($this, 'button_text', 'Button Text', 'TEXT', 'Button Text', [ '2','3' ]);
		// tourm_url_fields($this, 'button_url', 'Button URL', [ '2','3' ]);

		// tourm_general_fields($this, 'button_text2', 'Button Text 2', 'TEXT', 'Button Text', [ '3' ]);
		// tourm_url_fields($this, 'button_url2', 'Button URL 2', [ '3' ]);

        $this->end_controls_section();

		//---------------------------------------
			//Style Section Start
		//---------------------------------------

		tourm_button_style_fields($this, '11', 'Button Styling', '{{WRAPPER}} .th-btn', ['2']);


	}

	protected function render() {

	$settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){
			echo '<div class="gallery-area ">';
			echo '<div class="container th-container">';
			echo '<div class="row gy-10 gx-10 justify-content-center align-items-center">';
				if(!empty( $settings['image1']['url'] )){
	                echo '<div class="col-md-6 col-lg-2">';
	                    echo '<div class="gallery-card">';
	                        echo '<div class="box-img global-img">';
	                            echo '<a href="'.esc_url( $settings['image1']['url'] ).'" class="popup-image">';
	                                echo '<div class="icon-btn"><i class="fal fa-magnifying-glass-plus"></i></div>';
	                                echo '<img src="'.esc_url( $settings['image1']['url'] ).'" alt="gallery image">';
	                            echo '</a>';
	                        echo '</div>';
	                    echo '</div>';

	                echo '</div>';
	            }
                echo '<div class="col-md-6 col-lg-2">';
                	if(!empty( $settings['image2']['url'] )){
	                    echo '<div class="gallery-card">';
	                        echo '<div class="box-img global-img">';
	                            echo '<a href="'.esc_url( $settings['image2']['url'] ).'" class="popup-image">';
	                                echo '<div class="icon-btn"><i class="fal fa-magnifying-glass-plus"></i></div>';
	                                echo '<img src="'.esc_url( $settings['image2']['url'] ).'" alt="gallery image">';
	                            echo '</a>';
	                        echo '</div>';
	                    echo '</div>';
	                }
	                if(!empty( $settings['image3']['url'] )){
	                    echo '<div class="gallery-card">';
	                        echo '<div class="box-img global-img">';
	                            echo '<a href="'.esc_url( $settings['image3']['url'] ).'" class="popup-image">';
	                                echo '<div class="icon-btn"><i class="fal fa-magnifying-glass-plus"></i></div>';
	                                echo '<img src="'.esc_url( $settings['image3']['url'] ).'" alt="gallery image">';
	                            echo '</a>';
	                        echo '</div>';
	                    echo '</div>';
	                }
                echo '</div>';
                if(!empty( $settings['image4']['url'] )){
	                echo '<div class="col-md-6 col-lg-2">';
	                    echo '<div class="gallery-card">';
	                        echo '<div class="box-img global-img">';
	                            echo '<a href="'.esc_url( $settings['image4']['url'] ).'" class="popup-image">';
	                                echo '<div class="icon-btn"><i class="fal fa-magnifying-glass-plus"></i></div>';
	                                echo '<img src="'.esc_url( $settings['image4']['url'] ).'" alt="gallery image">';
	                            echo '</a>';
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	            }
                echo '<div class="col-md-6 col-lg-2">';
                	if(!empty( $settings['image5']['url'] )){
	                    echo '<div class="gallery-card">';
	                        echo '<div class="box-img global-img">';
	                            echo '<a href="'.esc_url( $settings['image5']['url'] ).'" class="popup-image">';
	                                echo '<div class="icon-btn"><i class="fal fa-magnifying-glass-plus"></i></div>';
	                                echo '<img src="'.esc_url( $settings['image5']['url'] ).'" alt="gallery image">';
	                            echo '</a>';
	                        echo '</div>';
	                    echo '</div>';
	                }
	                if(!empty( $settings['image6']['url'] )){
	                    echo '<div class="gallery-card">';
	                        echo '<div class="box-img global-img">';
	                            echo '<a href="'.esc_url( $settings['image6']['url'] ).'" class="popup-image">';
	                                echo '<div class="icon-btn"><i class="fal fa-magnifying-glass-plus"></i></div>';
	                                echo '<img src="'.esc_url( $settings['image6']['url'] ).'" alt="gallery image">';
	                            echo '</a>';
	                        echo '</div>';
	                    echo '</div>';
	                }
                echo '</div>';
                if(!empty( $settings['image7']['url'] )){
	                echo '<div class="col-md-6 col-lg-2">';
	                    echo '<div class="gallery-card">';
	                        echo '<div class="box-img global-img">';
	                            echo '<a href="'.esc_url( $settings['image7']['url'] ).'" class="popup-image">';
	                                echo '<div class="icon-btn"><i class="fal fa-magnifying-glass-plus"></i></div>';
	                                echo '<img src="'.esc_url( $settings['image7']['url'] ).'" alt="gallery image">';
	                            echo '</a>';
	                        echo '</div>';
	                    echo '</div>';

	                echo '</div>';
	            }
                
            echo '</div>';
            echo '</div>';
            echo '</div>';
		}elseif( $settings['layout_style'] == '2' ){
			echo '<div class="container th-container2">';
	            echo '<div class="row gy-24 gx-24 justify-content-center">';
	            	if(!empty( $settings['image1']['url'] )){
		                echo '<div class="col-lg-3 gallery-box_wrapp">';
		                    echo '<div class="gallery-box">';
		                        echo '<div class="gallery-img global-img">';
		                            echo '<a href="'.esc_url( $settings['image1']['url'] ).'" class="popup-image">';
		                                echo '<div class="icon-btn"><i class="fal fa-magnifying-glass-plus"></i></div>';
		                                echo '<img src="'.esc_url( $settings['image1']['url'] ).'" alt="gallery image">';
		                            echo '</a>';
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            }
	                echo '<div class="col-lg-3 gallery-box_wrapp">';
	                	if(!empty( $settings['image2']['url'] )){
		                    echo '<div class="gallery-box">';
		                        echo '<div class="gallery-img global-img">';
		                            echo '<a href="'.esc_url( $settings['image2']['url'] ).'" class="popup-image">';
		                                echo '<div class="icon-btn"><i class="fal fa-magnifying-glass-plus"></i></div>';
		                                echo '<img src="'.esc_url( $settings['image2']['url'] ).'" alt="gallery image">';
		                            echo '</a>';
		                        echo '</div>';
		                    echo '</div>';
		                }
		                if(!empty( $settings['image3']['url'] )){
		                    echo '<div class="gallery-box">';
		                        echo '<div class="gallery-img global-img">';
		                            echo '<a href="'.esc_url( $settings['image3']['url'] ).'" class="popup-image">';
		                                echo '<div class="icon-btn"><i class="fal fa-magnifying-glass-plus"></i></div>';
		                                echo '<img src="'.esc_url( $settings['image3']['url'] ).'" alt="gallery image">';
		                            echo '</a>';
		                        echo '</div>';
		                    echo '</div>';
		                }
	                echo '</div>';
	                echo '<div class="col-lg-3 gallery-box_wrapp">';
	                	if(!empty( $settings['image4']['url'] )){
		                    echo '<div class="gallery-box">';
		                        echo '<div class="gallery-img global-img">';
		                            echo '<a href="'.esc_url( $settings['image4']['url'] ).'" class="popup-image">';
		                                echo '<div class="icon-btn"><i class="fal fa-magnifying-glass-plus"></i></div>';
		                                echo '<img src="'.esc_url( $settings['image4']['url'] ).'" alt="gallery image">';
		                            echo '</a>';
		                        echo '</div>';
		                    echo '</div>';
		                }
		                if(!empty( $settings['image5']['url'] )){
		                    echo '<div class="gallery-box">';
		                        echo '<div class="gallery-img global-img">';
		                            echo '<a href="'.esc_url( $settings['image5']['url'] ).'" class="popup-image">';
		                                echo '<div class="icon-btn"><i class="fal fa-magnifying-glass-plus"></i></div>';
		                                echo '<img src="'.esc_url( $settings['image5']['url'] ).'" alt="gallery image">';
		                            echo '</a>';
		                        echo '</div>';
		                    echo '</div>';
		                }
	                echo '</div>';
	                if(!empty( $settings['image6']['url'] )){
		                echo '<div class="col-lg-3 gallery-box_wrapp">';
		                    echo '<div class="gallery-box">';
		                        echo '<div class="gallery-img global-img">';
		                            echo '<a href="'.esc_url( $settings['image6']['url'] ).'" class="popup-image">';
		                                echo '<div class="icon-btn"><i class="fal fa-magnifying-glass-plus"></i></div>';
		                                echo '<img src="'.esc_url( $settings['image6']['url'] ).'" alt="gallery image">';
		                            echo '</a>';
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            }
	            echo '</div>';
	        echo '</div>';
		}elseif( $settings['layout_style'] == '3' ){
			echo '<div class="row gy-24 gx-24 justify-content-center">';
				if(!empty( $settings['image1']['url'] )){
	                echo '<div class="col-lg-3">';
	                    echo '<div class="gallery-box style2">';
	                        echo '<div class="gallery-img global-img">';
	                            echo '<a href="'.esc_url( $settings['image1']['url'] ).'" class="popup-image">';
	                                echo '<div class="icon-btn"><i class="fal fa-magnifying-glass-plus"></i></div>';
	                                echo '<img src="'.esc_url( $settings['image1']['url'] ).'" alt="gallery image">';
	                            echo '</a>';
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	            }
                echo '<div class="col-lg-3">';
                	if(!empty( $settings['image2']['url'] )){
	                    echo '<div class="gallery-box style2">';
	                        echo '<div class="gallery-img global-img">';
	                            echo '<a href="'.esc_url( $settings['image2']['url'] ).'" class="popup-image">';
	                                echo '<div class="icon-btn"><i class="fal fa-magnifying-glass-plus"></i></div>';
	                                echo '<img src="'.esc_url( $settings['image2']['url'] ).'" alt="gallery image">';
	                            echo '</a>';
	                        echo '</div>';
	                    echo '</div>';
	                }
	                if(!empty( $settings['image3']['url'] )){
	                    echo '<div class="gallery-box style2">';
	                        echo '<div class="gallery-img global-img">';
	                            echo '<a href="'.esc_url( $settings['image3']['url'] ).'" class="popup-image">';
	                                echo '<div class="icon-btn"><i class="fal fa-magnifying-glass-plus"></i></div>';
	                                echo '<img src="'.esc_url( $settings['image3']['url'] ).'" alt="gallery image">';
	                            echo '</a>';
	                        echo '</div>';
	                    echo '</div>';
	                }
                echo '</div>';
                echo '<div class="col-lg-6 ">';
                	if(!empty( $settings['image4']['url'] )){
	                    echo '<div class="gallery-box style2">';
	                        echo '<div class="gallery-img global-img">';
	                            echo '<a href="'.esc_url( $settings['image4']['url'] ).'" class="popup-image">';
	                                echo '<div class="icon-btn"><i class="fal fa-magnifying-glass-plus"></i></div>';
	                                echo '<img src="'.esc_url( $settings['image4']['url'] ).'" alt="gallery image">';
	                            echo '</a>';
	                        echo '</div>';
	                    echo '</div>';
	                }
                    echo '<div class="gallery-box-wrapp">';
                    	if(!empty( $settings['image5']['url'] )){
	                        echo '<div class="gallery-box style2">';
	                            echo '<div class="gallery-img global-img">';
	                                echo '<a href="'.esc_url( $settings['image5']['url'] ).'" class="popup-image">';
	                                    echo '<div class="icon-btn"><i class="fal fa-magnifying-glass-plus"></i></div>';
	                                    echo '<img src="'.esc_url( $settings['image5']['url'] ).'" alt="gallery image">';
	                                echo '</a>';
	                            echo '</div>';
	                        echo '</div>';
	                    }
	                    if(!empty( $settings['image6']['url'] )){
	                        echo '<div class="gallery-box style2">';
	                            echo '<div class="gallery-img global-img">';
	                                echo '<a href="'.esc_url( $settings['image6']['url'] ).'" class="popup-image">';
	                                    echo '<div class="icon-btn"><i class="fal fa-magnifying-glass-plus"></i></div>';
	                                    echo '<img src="'.esc_url( $settings['image6']['url'] ).'" alt="gallery image">';
	                                echo '</a>';
	                            echo '</div>';
	                        echo '</div>';
	                    }
                    echo '</div>';
                echo '</div>';
            echo '</div>';
		}elseif( $settings['layout_style'] == '4' ){
			echo '<div class="sidebar-gallery-area space">';
		        echo '<div class="container-fluid">';
		            echo '<div class="slider-area">';
		                echo '<div class="swiper th-slider has-shadow" data-slider-options=\'{"centeredSlides":"true","breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"2"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"3"},"1300":{"slidesPerView":"4"}}}\'>';
		                    echo '<div class="swiper-wrapper">';
		                        foreach( $settings['logos'] as $data ){
			                        echo '<div class="swiper-slide">';
			                            echo '<div class="gallery-thumb style2 global-img">';
			                                echo tourm_img_tag( array(
												'url'   => esc_url( $data['slider_image']['url'] ),
											) );
			                                echo '<a target="_blank" href="https://www.instagram.com/" class="gallery-btn"><i class="fab fa-instagram"></i></a>';
			                            echo '</div>';
			                        echo '</div>';
			                    }
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}elseif( $settings['layout_style'] == '5' ){
			echo '<div class="widget footer-widget">';
				if( !empty( $settings['title'] ) ){
					echo '<h3 class="widget_title">'.esc_html( $settings['title'] ).'</h3>';
				}
                echo '<div class="sidebar-gallery">';
                    foreach( $settings['logos'] as $data ){
	                    echo '<div class="gallery-thumb">';
	                        echo tourm_img_tag( array(
								'url'   => esc_url( $data['slider_image']['url'] ),
							) );
	                        echo '<a target="_blank" href="https://www.instagram.com/" class="gallery-btn"><i class="fab fa-instagram"></i></a>';
	                    echo '</div>';
	                }
                echo '</div>';
            echo '</div>';
		}elseif( $settings['layout_style'] == '6' ){
			echo '<div class="container-fuild">';
				echo '<div class="row gy-4 gallery-row4">';
	                foreach( $settings['logos'] as $data ){
		                echo '<div class="col-auto">';
		                    echo '<div class="gallery-box style5">';
		                        echo '<div class="gallery-img global-img">';
		                            echo tourm_img_tag( array(
										'url'   => esc_url( $data['slider_image']['url'] ),
									) );
		                            echo '<a href="'.esc_url( $data['slider_image']['url'] ).'" class="icon-btn popup-image"><i class="fal fa-magnifying-glass-plus"></i></a>';
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            }
	            echo '</div>';
            echo '</div>';
		}elseif( $settings['layout_style'] == '7' ){
			echo '<div class="slider-area">';
                echo '<div class="swiper th-slider has-shadow" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"2"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"4"},"1400":{"slidesPerView":"6"}}}\'>';
                    echo '<div class="swiper-wrapper">';
                        foreach( $settings['logos2'] as $data ){
                        	$url = $data['url'] ? $data['url'] : '#';

	                        echo '<div class="swiper-slide">';
	                            echo '<div class="gallery-thumb2">';
	                                echo tourm_img_tag( array(
										'url'   => esc_url( $data['slider_image']['url'] ),
									) );
	                                echo '<a target="_blank" href="'.esc_url( $url ).'" class="gallery-btn"><i class="fab fa-instagram"></i></a>';
	                            echo '</div>';
	                        echo '</div>';
	                    }
                    echo '</div>';
                echo '</div>';
            echo '</div>';
		}else{
			echo '<div class="slider-area">';
                echo '<div class="swiper th-slider destination-slider2 " id="destiSlider1" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"2"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"3"}},"effect":"coverflow","coverflowEffect":{"rotate":"-17","stretch":"-8","depth":"330","modifier":"1","slideShadows":"false"},"centeredSlides":"true"}\'>';
                    echo '<div class="swiper-wrapper">';

                        foreach( $settings['logos'] as $data ){
	                        echo '<div class="swiper-slide">';
	                            echo '<div class="destination-box2 gsap-cursor">';
	                                echo '<div class="destination-img">';
	                                    echo tourm_img_tag( array(
											'url'   => esc_url( $data['slider_image']['url'] ),
										) );
	                                    echo '<a href="'.esc_url( $data['slider_image']['url'] ).'" class="popup-image">';
	                                        echo '<div class="icon-btn"><i class="fal fa-magnifying-glass-plus"></i></div>';
	                                    echo '</a>';
	                                echo '</div>';
	                            echo '</div>';
	                        echo '</div>';
	                    }
                        


                    echo '</div>';
                echo '</div>';
                echo '<div class="icon-box mt-60 text-center">';
                    echo '<button data-slider-prev="#destiSlider1" class="slider-arrow style5 default"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/right-arrow2.svg" alt=""></button>';
                    echo '<button data-slider-next="#destiSlider1" class="slider-arrow style5 default"><img src="'.TOURAM_PLUGDIRURI . 'assets/img/icon/left-arrow2.svg" alt=""></button>';
                echo '</div>';
            echo '</div>';
		}
	}
}